import torch
from torch.autograd import Variable
from utils.initial_x import getU, getV, getH

def Jorth_CSinitial(d,p):
    dim_theta = int(d / 2)
    dim_mu = int(d - p)
    dim_ksi = int(d / 2)
    theta0 = torch.randn(dim_theta)
    mu0 = torch.randn(dim_mu)
    ksi0 = torch.randn(dim_ksi)
    U0 = getU(theta0)
    H0 = getH(d, p, mu0)
    V0 = getV(ksi0)
    X0 = torch.mm(U0, torch.mm(H0, V0))
    return theta0, mu0, ksi0, X0
