import torch
from architectures.recurrent.rnn_module_custom import RNNModule

class RNN(torch.nn.Module):
    def __init__(self,
        device,
        input_dim, output_dim,
        latent_dim=500,
        nonlinearity='sigmoid',
        dropouts=[0,0,0],
        bias=False
    ):
        super().__init__()

        # ENCODER

        self.rnn = RNNModule(
            device,
            input_dim, latent_dim,
            nonlinearity=nonlinearity,
            dropouts=dropouts,
            input_bias=bias, hidden_bias=bias
        )

        # DECODER
        
        self.decoder_lin = torch.nn.Linear(latent_dim, output_dim, bias=bias)

        self.add_do = dropouts[-1] > 0
        self.decoder_do = torch.nn.Dropout(dropouts[-1])

    def encode(self, x, hidden):
        """ Encodes the input tensor into a latent representation.

        Args:
            x: [BATCH SIZE, TIME, CHANNELS, HEIGHT, WIDTH]
        """
        
        if hidden is not None:
            return self.rnn(x, hidden[None, ...])[0]
        else:
            return self.rnn(x)[0]

    def decode(self, x):
        decoded_lin = self.decoder_lin(x)
        if self.add_do:
            decoded_lin = self.decoder_do(decoded_lin)
        
        return decoded_lin
    
    def forward(self, inputs, hidden=None):
        hidden_all = self.encode(inputs, hidden)

        output = self.decode(hidden_all)

        return output, hidden_all, hidden_all[:,-1,:]
