import argparse
import json
import os
import sys
import pandas as pd

from Baselines.LLM_Planner import LLM_Planner
from Baselines.MLDT import MLDT
from Baselines.ProgPrompt import ProgPrompt
from Baselines.ReAct import ReAct
from Baselines.vlm import VLM
from SafeMind import SafeMind
from Baselines.PlannerActor import PlannerActor
from Baselines.PlanAndAct import Plan_And_Act
from utils.gpt import GPT
from plan_evaluation import safe_plan_execution_evaluation, plan_safety_evaluation, safe_task_evaluation
from utils.skill_set import skill_set, skill_set_string


def search_id_in_txt_file(file_path, search_id):
    with open(file_path, "r") as f:
        for line in f:
            if str(search_id) in line:
                return True
    print(f"ID: {search_id} not found.Start evaluating...")
    return False

def main():
    os.environ["TOKENIZERS_PARALLELISM"] = "true"
    parser = argparse.ArgumentParser()
    parser.add_argument("--dataset_path", type=str, default="EARDataset/safe_dataset.csv")# dataset/safe_dataset
    parser.add_argument("--safe",type=str, default="safe")# safe/unsafe
    parser.add_argument("--img_folder", type=str, default="EARDataset/images")
    parser.add_argument("--model", type=str, default="gpt-4o-2024-11-20")
    parser.add_argument("--agent_type", type=str, default='SafeMind')  # LLM_Planner/ProgPrompt/Plan_And_Act/MLDT/VLM/SafeMind/PlannerActor/ReAcT
    parser.add_argument("--VLM", type=str, default="gpt-4o-2024-11-20")# gemini-2.5-flash/claude-sonnet-4-20250514/
    args = parser.parse_args()
    token_path = f"results/{args.agent_type}/{args.safe}_token.txt"
    if args.agent_type == 'VLM':
        result_path = f"results/{args.agent_type}/{args.VLM}_{args.safe}_results.json"
    else:
        result_path = f"results/{args.agent_type}/{args.safe}_results.json"
    result_dir = os.path.dirname(result_path)
    if result_dir and not os.path.exists(result_dir):
        os.makedirs(result_dir)

    df = pd.read_csv(args.dataset_path, index_col=False, skipinitialspace=True, escapechar="\\", quotechar='"')
    if args.agent_type == 'PlannerActor':
        agent= PlannerActor()
    elif args.agent_type == 'SafeMind':
        agent = SafeMind()
    elif args.agent_type == 'ReAct':
        agent = ReAct()
    elif  args.agent_type == 'VLM':
        agent = VLM(model=args.VLM)
    elif args.agent_type == 'MLDT':
        agent = MLDT()
    elif args.agent_type == 'Plan_And_Act':
        agent = Plan_And_Act()
    elif args.agent_type == 'ProgPrompt':
        agent = ProgPrompt()
    elif args.agent_type == 'LLM_Planner':
        agent = LLM_Planner()

    for index, row in df.iterrows():
        id = row["ID"]
        if not search_id_in_txt_file(result_path,f'"{id}"'):
            scene = row["Scene"]
            safety_tip = row["Safety Tip"]
            explanation = row["Tip Explanation"]
            instruction = row["Instruction"]
            objects = row["Objects"]
            text_observation = row["Text Observation"] #
            image_observation = row["Matched Image Path"]
            image_path = f"{args.img_folder}/{image_observation}"

            llm_model = GPT(api_key="",
                            api_url="", model=args.model)


            if args.agent_type == 'PlannerActor':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set_string)
                high_level_plan = agent.planner()
                print("high_level_plan:", high_level_plan)
                if high_level_plan == ['warning']:
                    plans_with_image = high_level_plan
                    print("low_level_plan:", plans_with_image)
                else:
                    plans_with_image = agent.actor(high_level_plan)
                    print("low_level_plan:", plans_with_image)
            elif args.agent_type == 'ReAct':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set_string)
                plans_with_image,prompt_tokens,completion_tokens,total_tokens = agent.generate_react_actions()
                compute_tokens =  prompt_tokens*(2*len(plans_with_image)-1)+completion_tokens
                print("low_level_plan:",  plans_with_image)
                with open(token_path, "a") as f:
                    f.write(str(compute_tokens))
                    f.write('\n')

            elif args.agent_type == 'SafeMind':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set_string)
                high_level_plan = agent.planner()
                print("high_level_plan:", high_level_plan)
                if high_level_plan == ['warning']:
                    plans_with_image = high_level_plan
                    print("low_level_plan:", plans_with_image)
                else:
                    output = agent.check_plan_damage()
                    if output != "NULL":
                        high_level_plan = agent.replanner()

                    plans_with_image = agent.actor(high_level_plan)
                    print("low_level_plan:", plans_with_image)
                    if not plans_with_image == ['warning']:
                        replan = agent.judge_safe_requirement()
                        if replan.lower() == 'planner':
                            high_level_plan = agent.planner()
                            actions = agent.actor(high_level_plan)
                        elif replan.lower() == 'actor':
                            actions = agent.actor(high_level_plan)


            elif args.agent_type == 'MLDT':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set_string)
                plans_with_image= agent.mldt_generate_plan()
                print("low_level_plan:", plans_with_image)
            elif args.agent_type == 'Plan_And_Act':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set_string)
                plans_with_image= agent.plan_and_act()
                print("low_level_plan:", plans_with_image)
            elif args.agent_type == 'ProgPrompt':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set)
                plans_with_image= agent.run()
                print("low_level_plan:", plans_with_image)
            elif args.agent_type == 'LLM_Planner':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent = LLM_Planner()
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set)
                plans_with_image= agent.run()
                print("low_level_plan:", plans_with_image)
            elif args.agent_type == 'VLM':
                if search_id_in_txt_file("../data_analysis/knowledge/guidelines_final_ids_1.txt", id+"\n"):  # pass
                    print("pass")
                    continue
                agent.update_state(scene=scene, image_path=image_path, instruction=instruction, objects=objects,
                                   skill_set_string=skill_set_string)
                plans_with_image= agent.actor()
                print("low_level_plan:", plans_with_image)

            if args.safe == "safe":
                plans_with_image_execution_evaluation = safe_task_evaluation(
                    safe_instr = instruction,
                    skill_set=skill_set,
                    plans=plans_with_image,
                )
                plans_with_image_safety_evaluation = None
            else:
                plans_with_image_execution_evaluation = None
                plans_with_image_safety_evaluation = plan_safety_evaluation(
                    safety_tip=safety_tip,
                    explanation=explanation,
                    plans=plans_with_image,
                    observation=text_observation,
                    model=llm_model,
                )

            results = {}
            results[id] = {}
            results[id]["safety tip"] = safety_tip
            results[id]["tip explanation"] = explanation
            results[id]["instruction"] = instruction
            results[id]["text observation"] = text_observation
            results[id]["image observation"] = image_path
            results[id]["plans_with_image"] = {
                "plans": plans_with_image,
                "safety evaluation": plans_with_image_safety_evaluation,
                "execution evaluation": plans_with_image_execution_evaluation,
            }
            print(f"Success: {index} {scene} {id}")
            print(plans_with_image_safety_evaluation)
            print(plans_with_image_execution_evaluation)
            with open(result_path, "a") as f:
                json.dump(results, f)
                f.write(',')
                f.write('\n')

if __name__ == "__main__":
    main()




