
# RoDesigner
RoDesigner is a PyTorch-based variation-aware optimization for analog circuit design, it is one of the contributions of the work 
"RoDesigner: Variation-Aware Optimization for Robust Analog Design with Multi-Task RL"


## Features
- Easy integration of customize environment and reinforcement learning (RL) algorithms.
- Support parallel environment
- Support different types of circuit simulators.


## Installation
Download all files to local `RoDesigner` folder


## Usage
Run RoDesigner on Two-Stage OTA
```python
python run_ddpg_pcgrad_parallel.py kwargs/ngOTA/corner_30_logall.py --env=ng
```
Run DDPG on Two-Stage OTA
```python
python run_ddpg_pvt_ng.py kwargs/ngOTA/corner_30.py
```
Run ES on Two-Stage OTA
```python
python run_es.py kwargs/ngOTA/es_config_corner_30_pop_250.py
```


## Files
| File      | Description |
| ----------- | ----------- |
| run_ddpg_pcgrad_parallel.py   | RoDesigner framework on 3 circuit benchmarks |
| run_ddpg_pvt_ng.py   | DDPG on Two-Stage OTA |
| run_ddpg_pvt.py   | DDPG on Folded-Cascode OTA and strongARM Latch |
| run_es.py   | ES on 3 circuit benchmarks |
| envs/*   | PVT circuit simulation environment |
| open_source/*   | rlpyt framework |
| kwargs/*  | PVT corner setting |
| cluster/choose_next.py  | Corner task space pruning by k-means clustering |
| predictor/predictor.py   | Predict PVT corner performance by nominal corner performance |


## Dependencies
- Python >= 3.6
- PyTorch >= 1.7.0 
- scikitlearn >= 0.22.1
- kmeans-pytorch >= 0.3
- Circuit simulation requires Ngspice and Cadence Ocean
- Testbenches require corresponding PDK


## Notes
Cadence Ocean and PDK related benchmarks: Folded-Cascode OTA and strongARM OTA are removed due to NDA
To run Two-Stage OTA, please change 'XXX' in RoDesigner/envs/NGspiceOpamp/eval_engines/ngspice/ngspice_inputs/netlist/two_stage_opamp.cir
to your local directory path. This is because Ngspice netlist file is not compatible with relative path
