import numpy as np

from agent.utils.circuits_utils import get_model_static_features, get_mos_netlist_static_feature

kwargs = {
    'env': 'strongArmEnv',
    'nb_components': 25,
    'log_scale': True,
    'init_delta': 1,
    'nb_actions': 20,
    'prioritize': False,

    'topology': {
    'M0': ['net1', 'vip', 'net3', '0'],
    'M1': ['net1', 'vbp', 'vdd', 'vdd'],
    'M2': ['net3', 'vbn', '0', '0'],
    'M3': ['net4', 'vin', 'net3', '0'],
    'M4': ['net4', 'vbp', 'vdd', 'vdd'],
    'M5': ['vop', 'net1', 'vdd', 'vdd'],
    'M6': ['vop', 'vbn', '0', '0'],
    'M7': ['von', 'net4', 'vdd', 'vdd'],
    'M8': ['von', 'vbn', '0', '0'],
    'M9': ['vbp', 'vbn', '0', '0'],
    'M10': ['vbp', 'vbp', 'vdd', 'vdd'],
    'M11': ['vbn', 'vbn', '0', '0'],
    'M12': ['net3', 'vcmfb', '0', '0'],
    'M13': ['net015', 'vop', 'net18', 'vdd'],
    'M14': ['net021', 'vref', 'net18', 'vdd'],
    'M15': ['net18', 'vbp', 'vdd', 'vdd'],
    'M16': ['net021', 'net021', '0', '0'],
    'M17': ['net015', 'net015', '0', '0'],
    'M20': ['net015', 'von', 'net35', 'vdd'],
    'M21': ['net021', 'vref', 'net35', 'vdd'],
    'M22': ['net35', 'vbp', 'vdd', 'vdd'],
    'R0': ['net012', 'net1'],
    'R1': ['net011', 'net4'],
    'C0': ['net012', 'vop'],
    'C1': ['net011', 'von']
    },

    'sizing_types': ['w', 'l', 'mul', 'r', 'c'],

    'components': ['M0', 'M1', 'M2', 'M3', 'M4', 'M5', 'M6', 'M7', 'M8', 'M9', 'M10', 'M11', 'M12', 'M13', 'M14', 'M15',
                  'M16', 'M17', 'M20', 'M21', 'M22', 'R0', 'R1', 'C0', 'C1'],

    'sizing_names': ['w2_6_8_9_11_12_16_17', 'w1_4_10_15_22', 'w13_14_20_21', 'w0_3', 'w5_7',
                    'l2_6_8_9_11_12_16_17', 'l1_4_10_15_22', 'l13_14_20_21', 'l0_3', 'l5_7',
                    'mul16_17', 'mul12', 'mul6_8', 'mul2', 'mul1_4', 'mul15_22',
                    'r0_1', 'c0_1'
                    ],

    'component_out_type': {
        'M0': ['w', 'l'],
        'M1': ['w', 'l', 'mul'],
        'M2': ['w', 'l', 'mul'],
        'M3': ['w', 'l'],
        'M4': ['w', 'l', 'mul'],
        'M5': ['w', 'l'],
        'M6': ['w', 'l', 'mul'],
        'M7': ['w', 'l'],
        'M8': ['w', 'l', 'mul'],
        'M9': ['w', 'l'],
        'M10': ['w', 'l'],
        'M11': ['w', 'l'],
        'M12': ['w', 'l', 'mul'],
        'M13': ['w', 'l'],
        'M14': ['w', 'l'],
        'M15': ['w', 'l', 'mul'],
        'M16': ['w', 'l', 'mul'],
        'M17': ['w', 'l', 'mul'],
        'M20': ['w', 'l'],
        'M21': ['w', 'l'],
        'M22': ['w', 'l', 'mul'],
        'R0': ['r'],
        'R1': ['r'],
        'C0': ['c'],
        'C1': ['c']
    },


    'component_out_num': {
        'M0': 2,
        'M1': 3,
        'M2': 3,
        'M3': 2,
        'M4': 3,
        'M5': 2,
        'M6': 3,
        'M7': 2,
        'M8': 3,
        'M9': 2,
        'M10': 2,
        'M11': 2,
        'M12': 3,
        'M13': 2,
        'M14': 2,
        'M15': 3,
        'M16': 3,
        'M17': 3,
        'M20': 2,
        'M21': 2,
        'M22': 3,
        'R0': 1,
        'R1': 1,
        'C0': 1,
        'C1': 1
    },

    'component_out_num_list': [2,3,3,2,3,2,3,2,3,2, 2, 2, 3, 2, 2, 3, 3, 3, 2, 2, 3,1,1,1,1],

    'share_sizings': [
        [['M2', 'M6', 'M8', 'M9', 'M11', 'M12', 'M16', 'M17'], [0, 1]],
        [['M1', 'M4', 'M10', 'M15', 'M22'], [0, 1]],
        [['M13', 'M14', 'M20', 'M21'], [0, 1]],
        [['M0', 'M3'], [0, 1]],
        [['M5', 'M7'], [0, 1]],
        [['M16', 'M17'], [2]],
        [['M12'], [2]],
        [['M6', 'M8'], [2]],
        [['M2'], [2]],
        [['M1', 'M4'], [2]],
        [['M15', 'M22'], [2]],
        [['R0', 'R1'], [0]],
        [['C0', 'C1'], [0]]
    ],

    'indx_components_type': [21, 23, 25],
    'nmos_static_feat': get_model_static_features()[1],
    'pmos_static_feat': get_model_static_features()[0],
    'mos_netlist_static_feat': get_mos_netlist_static_feature(),

    'components_sizings_match': [
        [['M11', 'M9'],                 ['w2_6_8_9_11_12_16_17',    'l2_6_8_9_11_12_16_17', 1]                        ],
        [['M16', 'M17'],                ['w2_6_8_9_11_12_16_17',    'l2_6_8_9_11_12_16_17', 'mul16_17']               ],
        [['M12'],                       ['w2_6_8_9_11_12_16_17',    'l2_6_8_9_11_12_16_17', 'mul12']                  ],
        [['M6', 'M8'],                  ['w2_6_8_9_11_12_16_17',    'l2_6_8_9_11_12_16_17', 'mul6_8']                 ],
        [['M2'],                        ['w2_6_8_9_11_12_16_17',    'l2_6_8_9_11_12_16_17', 'mul2']                   ],
        [['M10'],                       ['w1_4_10_15_22',           'l1_4_10_15_22',        1]                        ],
        [['M1', 'M4'],                  ['w1_4_10_15_22',           'l1_4_10_15_22',        'mul1_4']                 ],
        [['M15', 'M22'],                ['w1_4_10_15_22',           'l1_4_10_15_22',        'mul15_22']               ],
        [['M13', 'M14', 'M20', 'M21'],  ['w13_14_20_21',            'l13_14_20_21',         1]                        ],
        [['M0', 'M3'],                  ['w0_3',                    'l0_3',                 1]                        ],
        [['M5', 'M7'],                  ['w5_7',                    'l5_7',                 1]                        ],
        [['R0', 'R1'],                  [                                                                'r0_1']      ],
        [['C0', 'C1'],                  [                                                                      'c0_1']]
        ],

    'components_type':
        {
            'M0':   'nmos',
            'M1':   'pmos',
            'M2':   'nmos',
            'M3':   'nmos',
            'M4':   'pmos',
            'M5':   'pmos',
            'M6':   'nmos',
            'M7':   'pmos',
            'M8':   'nmos',
            'M9':   'nmos',
            'M10':  'pmos',
            'M11':  'nmos',
            'M12':  'nmos',
            'M13':  'pmos',
            'M14':  'pmos',
            'M15':  'pmos',
            'M16':  'nmos',
            'M17':  'nmos',
            'M20':  'pmos',
            'M21':  'pmos',
            'M22':  'pmos',
            'R0':   'r',
            'R1':   'r',
            'C0':   'c',
            'C1':   'c'
        },
    'starting_sample': np.array([5.0040e+04, 1.4607e+05, 1.4430e+05, 1.1937e+05, 1.2810e+04, 1.0300e+03, 6.3000e+02,
                                 1.3300e+03, 3.3000e+02, 4.3000e+02, 1.6000e+01, 1.7000e+01, 1.9000e+01, 1.4000e+01,
                                 9.0000e+00, 1.2000e+01, 5.0000e+00, 4.4100e+03]),
    

}


if __name__ == '__main__':
    print(len(kwargs['nmos_static_states']))
    print(len(kwargs['pmos_static_states']))
