# TDVAE

This repository contains code to accompany the SVRHM 2022 Workshop @ NeurIPS 
submission 12 "Top-down effects in an early visual cortex inspired
hierarchical Variational Autoencoder".

The code in this directory was derived from Dushyant Rao, Francesco
Visin, Andrei A. Rusu, Yee Whye Teh, Razvan Pascanu, and Raia Hadsell,
Continual unsupervised representation learning. arXiv:1910.14481
[cs.LG], 2019.

## Specification of dependencies

We recommend running this model in a Python 3.8.5 [virtual
environment](https://docs.python.org/3/tutorial/venv.html) as
```console
$ python -m venv .venv
$ source .venv/bin/activate
$ pip install -r requirements.txt

Model training:
$ python train_TDVAE40.py
$ python train_TDVAE40n.py
$ python train_TDVAE40125.py

Model evaluation:
1) Start Jupyter server:
$ jupyter lab
2) In the popping up web browser window, open and run
eval_TDVAE40.ipynb, eval_TDVAE40n.ipynb, or eval_TDVAE40125.ipynb.

Run `deactivate` to exit the virtual environment.
```

## Training code

To train the model TDVAE40 in the paper, perform the following
steps:
1. Create the necessary runtime environment and download the training
   dataset as described in [our root README.md](../README.md).
2. Run the training script with `python train_TDVAE40.py`, `python
   train_TDVAE40n.py`, or `python train_TDVAE40125.py`. These will
   output their results into the directories `log_TDVAE40`,
   `log_TDVAE40n`, or `log_TDVAE40125`, respectively.

## Evaluation code

To obtain the results mentioned regarding the model TDVAE40 in the
paper, perform the following steps:
1. Create the necessary runtime environment and download the training
   dataset as described in [our root README.md](../README.md).
2. Run the evaluation notebook `eval_TDVAE40.ipynb`,
   `eval_TDVAE40n.ipynb`, or `eval_TDVAE40125.ipynb`.
