# CHAINVAE

## Building docker image
Run the docker build command in the folder /visual-hvae/chain_VAE/docker

$docker build -t chain_vae:1.0 .

Make sure /visual-hvae/chain_VAE/documentation folder have write permission for all

$ chmod -R 777 ../documentation

Change directory to /visual-hvae

$ cd ../..

Run the container (from visual-hvae folder). Port bindings are only necessary if we would like to use jupyter-lab and tensorboard:

$ docker run -it --runtime=nvidia --name chain_container -d -p 8900:8888 -p 6100:6006 -v $PWD/chain_VAE:/home/ -v $PWD/datasets:/home/data/datasets/ chain_vae:1.0 bash

### Execution from the container
$ docker exec -it chain_container bash

### Model training
$cd /home/src
$python3 training_chainvae.py --name mymodel

With --large_beta argument the script trains the model with beta2=1.25 (default beta2=1)

### Model evaluation
$ python3 eval_chainvae.py --name mymodel
The evaluation files will be at /home/documentation/experiments/{name}/analysis folder

### Downloading pretrained models
$ cd /home/documentation/experiments

$ ./download_pretrained_models

The pretrained model will have model folder with the name of "TD_comparison_40". This name will need to
be used when running the evalutaion script.
