"""Training file for the LinearVAE40 model in the paper
"""

import training


def main(unused_argv):
  train_eval_ops, test_eval_ops, sess, params, saver = \
      training.run_training(**{
          'tb_dir': None,
          'restore_from': None,
          'save_dir': 'log_LinearVAE40',
          'use_supervised_replay': False,
          'gen_replay_type': None,
          'knn_values': [],
          'report_interval': (640000 // 128) * 150,
          'classify_with_samples': False,
          'll_thresh': -200000.0,
          'dynamic_expansion': False,
          'z1_distr_kwargs': {'distr': 'laplace', 'sigma_nonlin': 'exp',
                              'sigma_param': 'var'},
          'decoder_kwargs': {'decoder_type': 'single', 'n_dec': [],
                             'dec_up_strides': None},
          'encoder_kwargs': {'encoder_type': 'multi', 'n_enc': [2000, 2000],
                             'enc_strides': [1]},
          'n_z': 1800,
          'n_y_active': 1,
          'n_y': 1,
          'output_sd': 0.4,
          'output_type': 'normal',
          'lr_schedule': [1],
          'lr_factor': 1.0,
          'lr_init': 0.00003,
          'random_seed': None,
          'n_steps': (640000 // 128) * 6000,
          'train_supervised': False,
          'blend_classes': False,
          'n_concurrent_classes': 1,
          'training_data_type': 'iid',
          'dataset_params': {'batch_size': 128, 'test_batch_size': 128,
                             'train_every': 2, 'test_every': 1, 'crop_dim': 40,
                             'path': '../datasets/fakelabeled_natural_commonfiltered_640000_40px.pkl',
                             'offset': 0.0},
          'dataset': 'textures',
          'beta_y_evo': 1, 'beta_z_evo': 1,
          'lambda_shared_encoder_bias': 0, 'lambda_latent_encoder_bias': 0})


if __name__ == '__main__':
  main([])
