#!/bin/bash

# sc_values=(0.01 0.05 0.10 0.30 0.50 0.70 0.90 0.95 0.99)
# ci_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)
# ai_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)

# sc_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)
# ci_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)
# ai_values=(0.01 0.05 0.10 0.30 0.50 0.70 0.90 0.95 0.99)

# sc_values=(0.01 0.05 0.10 0.30 0.50 0.70 0.90 0.95 0.99)
# ci_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)
# ai_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)

# sc_values=(0.01 0.05 0.10 0.30 0.50 0.70 0.90 0.95 0.99 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)
# ci_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.01 0.05 0.10 0.30 0.70 0.90 0.95 0.99 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50)
# ai_values=(0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.50 0.01 0.05 0.10 0.30 0.70 0.90 0.95 0.99)

sc_values=(0.68 0.50 0.30 0.51 0.40 0.57 0.17 0.51 0.55 0.47 0.49 0.52 0.23 0.12 0.36 0.15 0.50 0.49 0.48 0.26 0.28 0.68 0.27 0.25 0.23 0.59 0.72 0.67 0.64 0.70)
ci_values=(0.35 0.47 0.49 0.36 0.11 0.46 0.40 0.65 0.24 0.22 0.29 0.42 0.24 0.26 0.39 0.39 0.70 0.65 0.40 0.67 0.38 0.81 0.39 0.81 0.60 0.42 0.58 0.85 0.24 0.42)
ai_values=(0.47 0.31 0.71 0.27 0.65 0.36 0.49 0.70 0.47 0.52 0.55 0.16 0.64 0.80 0.45 0.68 0.65 0.66 0.57 0.17 0.75 0.69 0.53 0.12 0.21 0.46 0.61 0.69 0.36 0.33)

y_task=21
a_task=36
datasize=(200 500 1000 2000 5000 10000)
data_seed=0

# Define fixed parameters
algorithm="GroupDRO"
dataset="CelebA"
train_attr="yes"
data_dir="/resource/database"
# image_arch="vit_sup_in1k"
# output_dir="//exps/div_explore/celeba_${image_arch}"
image_arch="resnet_sup_in1k"
hparams_seed=0


# Check if the number of parameters passed is less than 1
if [ $# -lt 1 ]; then
    # Set default value if no parameter is passed
    seed=0
else
    # Set parameter to the first passed parameter
    seed="$1"
fi

# Loop over the indices of the arrays
for d in "${!datasize[@]}"; do
    n="${datasize[$d]}"
    output_dir="//exps/div_explore/celeba_v2/celeba_y${y_task}_a${a_task}_ds${data_seed}_n${n}"

    # check if output_dir exists, otherwise create one
    if [ ! -d "$output_dir" ]; then
        mkdir -p "$output_dir"
    fi

    for i in "${!sc_values[@]}"; do
        sc="${sc_values[$i]}"
        ci="${ci_values[$i]}"
        ai="${ai_values[$i]}"
        lower_algorithm=$(echo "$algorithm" | awk '{print tolower($0)}')  # Convert algorithm to lowercase
        output_folder_name="${lower_algorithm}/sc${sc}_ci${ci}_ai${ai}"
        metadata="//output/div_explore/celeba/celeba_v2/tasks_y${y_task}_a${a_task}_datasize${n}_seed${data_seed}/task_celeba_sc${sc}_ci${ci}_ai${ai}.csv"

        check_file="${output_dir}/${output_folder_name}_attr${train_attr^}/${dataset}_${algorithm}_hparams${hparams_seed}_seed${seed}/final_results.pkl"
        # check if check_file exists, if yes then skip
        if [ -f $check_file ]; then
            echo "Output file $check_file exists, skipping..."
            continue
        fi

        # Execute the command
        python -m subpopbench.train \
            --algorithm "$algorithm" \
            --dataset "$dataset" \
            --train_attr "$train_attr" \
            --data_dir "$data_dir" \
            --output_dir "$output_dir" \
            --output_folder_name "$output_folder_name" \
            --hparams_seed "$hparams_seed" \
            --seed "$seed" \
            --metadata "$metadata" \
            --image_arch "$image_arch"
    done
done








y_task=2
a_task=31
datasize=(200 500 1000 2000 5000 10000)
data_seed=0

# Define fixed parameters
algorithm="ERM"
dataset="CelebA"
train_attr="yes"
data_dir="/resource/database"
# image_arch="vit_sup_in1k"
# output_dir="//exps/div_explore/celeba_${image_arch}"
image_arch="resnet_sup_in1k"
hparams_seed=0



# Check if the number of parameters passed is less than 1
if [ $# -lt 1 ]; then
    # Set default value if no parameter is passed
    seed=0
else
    # Set parameter to the first passed parameter
    seed="$1"
fi

# Loop over the indices of the arrays
for d in "${!datasize[@]}"; do
    n="${datasize[$d]}"
    output_dir="//exps/div_explore/celeba_v2/celeba_y${y_task}_a${a_task}_ds${data_seed}_n${n}"

    # check if output_dir exists, otherwise create one
    if [ ! -d "$output_dir" ]; then
        mkdir -p "$output_dir"
    fi

    for i in "${!sc_values[@]}"; do
        sc="${sc_values[$i]}"
        ci="${ci_values[$i]}"
        ai="${ai_values[$i]}"
        lower_algorithm=$(echo "$algorithm" | awk '{print tolower($0)}')  # Convert algorithm to lowercase
        output_folder_name="${lower_algorithm}/sc${sc}_ci${ci}_ai${ai}"
        metadata="//output/div_explore/celeba/celeba_v2/tasks_y${y_task}_a${a_task}_datasize${n}_seed${data_seed}/task_celeba_sc${sc}_ci${ci}_ai${ai}.csv"

        check_file="${output_dir}/${output_folder_name}_attr${train_attr^}/${dataset}_${algorithm}_hparams${hparams_seed}_seed${seed}/final_results.pkl"
        # check if check_file exists, if yes then skip
        echo "Checking if file $check_file exists..."
        if [ -f $check_file ]; then
            echo "File exists, skipping..."
            continue
        fi

        # Execute the command
        python -m subpopbench.train \
            --algorithm "$algorithm" \
            --dataset "$dataset" \
            --train_attr "$train_attr" \
            --data_dir "$data_dir" \
            --output_dir "$output_dir" \
            --output_folder_name "$output_folder_name" \
            --hparams_seed "$hparams_seed" \
            --seed "$seed" \
            --metadata "$metadata" \
            --image_arch "$image_arch"
    done
done

