Code Implementation Guide

Our codebase is organized into separate modules for different attack types:
• Random State Attack

• Random Element Attack  

• Adversarial State Attack

• Adversarial Element Attack

Setup Instructions:

1. Install the environment
   • run `pip install -r requirements.txt'

2. Dataset Preparation
   • Go to the specific codebase `random_state`/`random_element`/`adversarial_state`/`adversarial_element`

   • Execute `./scripts/download_datasets.py` to fetch D4RL benchmark datasets

   • Store all downloaded datasets in the `./datasets` directory


3. Execution
   • Run the main script: `./run.bash`

   • When prompted, select your configuration:

     ◦ Dataset type: `random`/`medium`/`medium-replay`/`medium-expert`/`expert`

     ◦ Environment: `halfcheetah`/`hopper`/`walker2d`

4. Output Utilization  
   The processed datasets can be directly used with [CORL](https://github.com/tinkoff-ai/CORL), the official Conservative Offline RL implementation.

Note:
Each attack variant maintains its own dedicated codebase to ensure modularity and clear separation of functionality.