# DataFreeShield

## Sample Synthesis
python3 diversified_sample_synthesis.py --model resnet20_cifar10 --save_root ./rn20_cifar10/ --num_total_images 10000 --seed [random_seed] --gpu [gpu_id]
python3 diversified_sample_synthesis.py --model resnet56_cifar10 --save_root ./rn56_cifar10/ --num_total_images 10000 --seed [random_seed] --gpu [gpu_id]
python3 diversified_sample_synthesis.py --model wrn28_10_cifar10 --save_root ./wrn28_cifar10/ --num_total_images 10000 --seed [random_seed] --gpu [gpu_id]

python3 diversified_sample_synthesis.py --model resnet20_svhn --save_root ./rn20_svhn/ --num_total_images 10000 --seed [random_seed] --gpu [gpu_id]
python3 diversified_sample_synthesis.py --model resnet56_svhn --save_root ./rn56_svhn/ --num_total_images 10000 --seed [random_seed] --gpu [gpu_id]
python3 diversified_sample_synthesis.py --model wrn28_10_svhn --save_root ./wrn28_svhn/ --num_total_images 10000 --seed [random_seed] --gpu [gpu_id]

## Merge Dataset
python3 merge_dataset.py --root [/path/to/save/dataset] --model resnet20 --dataset cifar10

## Robustness Training
python3 main.py --conf_path cifar10_robust_student.hocon --advloss DFShieldLoss --model resnet20 --train_eps 4 --train_step_size 1 --eps 4 --step_size 1 --exp_name rn20_cifar10_dfshield  --data_pth [path/to/dataset] --p_thresh 0.5 --agg_iter 20
python3 main.py --conf_path svhn_robust_student.hocon --advloss DFShieldLoss --model resnet56 --train_eps 8 --train_step_size 2 --eps 8 --step_size 2 --exp_name rn56_svhn_dfshield  --data_pth [path/to/dataset] --p_thresh 0.5 --agg_iter 20