import torch
import torch.nn as nn
import torch.nn.functional as F
from torch.autograd import Variable


def rslad_loss(model,
              x_natural,
              y,
              teacher_outputs,
              optimizer,
              step_size=0.007,
              epsilon=0.031,
              perturb_steps=10,
              distance='l_inf'):
    kl = nn.KLDivLoss(size_average=False,reduce=False).cuda()
    model.eval()
    batch_size = len(x_natural)
    # generate adversarial example
    x_adv = x_natural.detach() + 0.001 * torch.randn(x_natural.shape).cuda().detach()
    if distance == 'l_inf':
        for _ in range(perturb_steps):
            x_adv.requires_grad_()
            with torch.enable_grad():
                loss_kl = kl(F.log_softmax(model(x_adv), dim=1),
                             F.softmax(teacher_outputs, dim=1))
                loss_kl = torch.sum(loss_kl)
            grad = torch.autograd.grad(loss_kl, [x_adv])[0]
            x_adv = x_adv.detach() + step_size * torch.sign(grad.detach())
            x_adv = torch.min(torch.max(x_adv, x_natural - epsilon), x_natural + epsilon)
            x_adv = torch.clamp(x_adv, 0.0, 1.0)
    else:
        x_adv = torch.clamp(x_adv, 0.0, 1.0)

    model.train()

    x_adv = Variable(torch.clamp(x_adv, 0.0, 1.0), requires_grad=False)
    # zero gradient
    optimizer.zero_grad()
    
    logits = model(x_natural)
    logits_adv = model(x_adv)

    kl_loss1 = kl(F.log_softmax(logits_adv, dim=1), F.softmax(teacher_outputs.detach(),dim=1))
    kl_loss2 = kl(F.log_softmax(logits, dim=1), F.softmax(teacher_outputs.detach(), dim=1))
    kl_loss1 = torch.mean(kl_loss1)
    kl_loss2 = torch.mean(kl_loss2)
    loss_robust = 5/6.0*kl_loss1 + 1/6.0*kl_loss2 #weights taken from original implementation..

    return logits_adv, loss_robust