import numpy as np

"""
This file contains three helper functions that inversely sample time t_i 
from exponential, rayleigh, and power-law distribution, respectively.

Each function takes inputs
alpha_ji -- a vector of transmission rates from node j to other nodes i!=j
t_j -- a scalar of node j's infection time
and outputs
t_i -- a vector sample of other nodes i's infection time by node j.

inv_pow takes an additional input delta, the parameter in power-law distribution

"""


def inv_exp(alpha_ji, t_j, eps=10**-8):
    alpha_ji[alpha_ji == 0] = eps
    r = np.random.uniform(0, 1, alpha_ji.shape)
    return t_j - np.log(1 - r) / alpha_ji


def inv_ray(alpha_ji, t_j, eps=10**-8):
    alpha_ji[alpha_ji == 0] = eps
    r = np.random.uniform(0, 1, alpha_ji.shape)
    return t_j + np.sqrt(-2 * np.log(1 - r) / alpha_ji)


def inv_pow(alpha_ji, t_j, delta, eps=10**-8):
    alpha_ji[alpha_ji == 0] = eps
    r = np.random.uniform(0, 1, alpha_ji.shape)
    return t_j + delta * np.exp(- np.log(1 - r) / alpha_ji)
