import numpy as np
from data_gen import gen_cascade

np.random.seed(234)

# This experiment uses dist = "exp", "ray", "pow" and t = 1, 2, 3, 4, 5, 10
dist = "pow"
delta = 0.25

nd = 200
num_case = 20
nc = 1500
t = 1

# In this test, we use theta and psi from test 3 where the level of overlap is 0.3
# Generate cascade samples
for ii in range(num_case):
    P_pathway = 0.5 * np.ones(nd)
    Z_record = np.zeros((nc, nd))

    cascades = np.zeros((nc, nd))
    for i in range(nc):
        Z = np.random.binomial(1, P_pathway, size=nd)
        Z_record[i, :] = Z
        Theta = A * np.ones((nd, nd)) @ np.diag(Z) + B_use * np.ones((nd, nd)) @ np.diag(1 - Z)

        cascades[i, :] = gen_cascade(Theta, t, nd, dist, delta)