#!/usr/bin/env python3

import sys
import signal
import json
from random import choice
from sympy import simplify, expand, latex
from sympy import expand, simplify, expand_trig, trigsimp, expand_log

TIMEOUT = 1
N = 3

def timeout(sec):
    def decorator(func):
        def handler(*args):
            raise TimeoutError
        signal.signal(signal.SIGALRM, handler)
        def wrapper(*args, **kwargs):
            signal.alarm(sec)
            return func(*args, **kwargs)
        return wrapper
    return decorator

def multisimp(x):
    #return simplify(expand_log(trigsimp(expand_trig(x))))
    return simplify(trigsimp(x))

multisimp = timeout(TIMEOUT)(multisimp)

with open(sys.argv[1]) as f:
    examples1 = [json.loads(l) for l in f.read().splitlines()]

with open(sys.argv[2]) as f:
    examples2 = [json.loads(l) for l in f.read().splitlines()]

ints = list(set(range(-9, 10)) - {0})
for example1 in examples1:
    expr1 = example1['sympy']
    for i in range(N):
        i1 = choice(ints)
        i2 = choice(ints)
        expr2 = choice(examples2)['sympy']
        expr = f'{i1} * ({expr1}) + {i2} * ({expr2})'
        print(expr, file=sys.stderr)
        try:
            expr = multisimp(expr)
            print(expr, file=sys.stderr)
        except TimeoutError:
            print('timeout', file=sys.stderr)
        print(file=sys.stderr)
        example = {}
        example['sympy'] = str(expr)
        example['latex'] = latex(expr)
        print(json.dumps(example))
