#!/usr/bin/env python3

import sys
import json
from random import sample

REPEAT=100

examples = sys.argv[1]
with open(examples) as f:
    examples = [json.loads(l) for l in f.read().splitlines()]
k = len(examples[0]['responses'])
print('Max number of responses:', k)
ks = []
while k > 0:
    ks.append(k)
    k = int(k / 2)
for k in ks:
    pass_rates = []
    for example in examples:
        correctness = [response['correct'] for response in example['responses']]
        correctness = [True if r else False for r in correctness]
        passed = []
        for _ in range(REPEAT):
            correctnes_k = sample(correctness, k)
            passed.append(sum(correctnes_k) > 0)
        avg_pass = sum(passed) / len(passed)
        pass_rates.append(avg_pass)
    avg_pass_rate = sum(pass_rates) / len(pass_rates)
    print(f'pass@{k:5} = {avg_pass_rate}')
