#!/usr/bin/env python3

import sys
import json
import signal
from random import shuffle, sample, choices, choice
from sympy import simplify, expand, parse_expr, diff, latex, Symbol
from sympy import expand, simplify, expand_trig, trigsimp, expand_log

TIMEOUT = 1
N = 3

def timeout(sec):
    def decorator(func):
        def handler(*args):
            raise TimeoutError
        signal.signal(signal.SIGALRM, handler)
        def wrapper(*args, **kwargs):
            signal.alarm(sec)
            return func(*args, **kwargs)
        return wrapper
    return decorator

def multisimp(x):
    #return simplify(expand_log(trigsimp(expand_trig(x))))
    return simplify(trigsimp(x))

multisimp = timeout(TIMEOUT)(multisimp)

with open(sys.argv[1]) as f:
    examples = [json.loads(l) for l in f.read().splitlines()]

with open(sys.argv[2]) as f:
    examples_subst = [json.loads(l) for l in f.read().splitlines()]

x = Symbol('x', real=True)

for example in examples:
    expr = parse_expr(example['sympy'])
    print(file=sys.stderr)
    print(expr, file=sys.stderr)
    for i in range(N):
        example_subst = choice(examples_subst)
        g = parse_expr(example_subst['sympy_integral'])
        g_prim = parse_expr(example_subst['sympy'])
        expr_new = expr.subs('x', g) * g_prim
        try:
            expr_new_simp = multisimp(expr_new)
        except:
            expr_new_simp = expr_new
            print('timeout', file=sys.stderr)
        if len(str(expr_new_simp)) < len(str(expr_new)):
            expr_new = expr_new_simp
        print(expr_new, file=sys.stderr)
        example = {}
        example['sympy'] = str(expr_new)
        example['latex'] = latex(expr_new)
        example['sympy_orig'] = str(expr)
        example['subst'] = str(g)
        print(json.dumps(example))
