#!/usr/bin/env python3

import sys
import json
import signal
from random import shuffle, sample, choices
from sympy import simplify, expand, parse_expr, diff, latex, Symbol
from sympy import expand, simplify, expand_trig, trigsimp, expand_log

TIMEOUT = 1
N = 3

def timeout(sec):
    def decorator(func):
        def handler(*args):
            raise TimeoutError
        signal.signal(signal.SIGALRM, handler)
        def wrapper(*args, **kwargs):
            signal.alarm(sec)
            return func(*args, **kwargs)
        return wrapper
    return decorator

def multisimp(x):
    #return simplify(expand_log(trigsimp(expand_trig(x))))
    return simplify(trigsimp(x))

multisimp = timeout(TIMEOUT)(multisimp)

with open(sys.argv[1]) as f:
    examples = [json.loads(l) for l in f.read().splitlines()]

x = Symbol('x', real=True)

for example in examples:
    expr = parse_expr(example['sympy'])
    print('\n', expr, file=sys.stderr)
    for i in range(N):
        a = choices(list(range(-9,10)), k=4)
        g = a[3] * x ** 3 + a[2] * x ** 2 + a[1] * x + a[0]
        expr_new = expr.subs('x', g) * diff(g)
        try:
            expr_new = multisimp(expr_new)
        except:
            print('timeout', file=sys.stderr)
        print(expr_new, file=sys.stderr)
        example = {}
        example['sympy'] = str(expr_new)
        example['latex'] = latex(expr_new)
        example['sympy_orig'] = str(expr)
        example['subst'] = str(g)
        print(json.dumps(example))
