import re
import signal

from sympy import sech, csch, asec, acot, acsc, acosh, asinh, atanh, asech, acsch, acoth, sign
from sympy import Function


def vote(votes):
    return max(set(votes), key=votes.count)

def log_args(args):
    args = vars(args)
    for a in args:
        print(f'ARGUMENT: {a}={args[a]}')

def timeout(sec):
    def decorator(func):
        def handler(*args):
            raise TimeoutError
        signal.signal(signal.SIGALRM, handler)
        def wrapper(*args, **kwargs):
            signal.alarm(sec)
            return func(*args, **kwargs)
        return wrapper
    return decorator

def extract_final_answer(answer):
    answer = answer.replace('\n', ' ')
    answer = re.sub('  *', ' ', answer)
    r = re.compile(r"(\\boxed\{)(?!.*boxed.*)(.*)(\})")
    final_answer = r.findall(answer)
    if final_answer:
        final_answer = final_answer[-1][1]
        if '=' in final_answer:
            final_answer = final_answer.split('=')[-1].strip()
        return final_answer
    return ''

def malformed(final_answer):
    if not final_answer:
        return True
    if 'x' not in final_answer:
        return True
    disallowed_words = {
       r'\int ',
       r'\mathrm{',
       r'{cases}',
       'constant',
    }
    for w in disallowed_words:
        if w in final_answer:
            return True
    disallowed_pattern = re.compile(r'[a-z]{3,} [a-z]{3,}')
    if re.search(disallowed_pattern, final_answer):
        return True
    return False

def nonstandard_operators_pre(latex_expr):
    subs_dict = {
        r'\operatorname{sech}':    r'\sechaux',
        r'\operatorname{csch}':    r'\cschaux',
        r'\operatorname{arcsec}':  r'\arcsecaux',
        r'\operatorname{arccot}':  r'\arccotaux',
        r'\operatorname{arccsc}':  r'\arccscaux',
        r'\operatorname{arccosh}': r'\arccoshaux',
        r'\operatorname{arcsinh}': r'\arcsinhaux',
        r'\operatorname{arctanh}': r'\arctanhaux',
        r'\operatorname{arcsech}': r'\arcsechaux',
        r'\operatorname{arccsch}': r'\arccschaux',
        r'\operatorname{arccoth}': r'\arccothaux',
        r'\operatorname{arsec}':   r'\arcsecaux',
        r'\operatorname{arcot}':   r'\arccotaux',
        r'\operatorname{arcsc}':   r'\arccscaux',
        r'\operatorname{arcosh}':  r'\arccoshaux',
        r'\operatorname{arsinh}':  r'\arcsinhaux',
        r'\operatorname{artanh}':  r'\arctanhaux',
        r'\operatorname{arsech}':  r'\arcsechaux',
        r'\operatorname{arcsch}':  r'\arccschaux',
        r'\operatorname{arcoth}':  r'\arccothaux',
        r'\operatorname{asec}':    r'\arcsecaux',
        r'\operatorname{acot}':    r'\arccotaux',
        r'\operatorname{acsc}':    r'\arccscaux',
        r'\operatorname{acosh}':   r'\arccoshaux',
        r'\operatorname{asinh}':   r'\arcsinhaux',
        r'\operatorname{atanh}':   r'\arctanhaux',
        r'\operatorname{asech}':   r'\arcsechaux',
        r'\operatorname{acsch}':   r'\arccschaux',
        r'\operatorname{acoth}':   r'\arccothaux',
        r'\operatorname{sgn}':     r'\sgnaux',
        r'\text{sech}':            r'\sechaux',
        r'\text{csch}':            r'\cschaux',
        r'\text{arcsec}':          r'\arcsecaux',
        r'\text{arccot}':          r'\arccotaux',
        r'\text{arccsc}':          r'\arccscaux',
        r'\text{arccosh}':         r'\arccoshaux',
        r'\text{arcsinh}':         r'\arcsinhaux',
        r'\text{arctanh}':         r'\arctanhaux',
        r'\text{arcsech}':         r'\arcsechaux',
        r'\text{arccsch}':         r'\arccschaux',
        r'\text{arccoth}':         r'\arccothaux',
        r'\text{arsec}':           r'\arcsecaux',
        r'\text{arcot}':           r'\arccotaux',
        r'\text{arcsc}':           r'\arccscaux',
        r'\text{arcosh}':          r'\arccoshaux',
        r'\text{arsinh}':          r'\arcsinhaux',
        r'\text{artanh}':          r'\arctanhaux',
        r'\text{arsech}':          r'\arcsechaux',
        r'\text{arcsch}':          r'\arccschaux',
        r'\text{arcoth}':          r'\arccothaux',
        r'\text{asec}':            r'\arcsecaux',
        r'\text{acot}':            r'\arccotaux',
        r'\text{acsc}':            r'\arccscaux',
        r'\text{acosh}':           r'\arccoshaux',
        r'\text{asinh}':           r'\arcsinhaux',
        r'\text{atanh}':           r'\arctanhaux',
        r'\text{asech}':           r'\arcsechaux',
        r'\text{acsch}':           r'\arccschaux',
        r'\text{acoth}':           r'\arccothaux',
        r'\text{sgn}':             r'\sgnaux',
        # parse_latex understands these below in the right column
        r'\operatorname{asin}':  r'\arcsin ',
        r'\operatorname{acos}':  r'\arccos ',
        r'\operatorname{atan}':  r'\arctan ',
    }
    for e in subs_dict:
        latex_expr = latex_expr.replace(e, subs_dict[e])
    return latex_expr

def nonstandard_operators_post(sympy_expr):
    subs_dict = {
        'sechaux': sech,
        'cschaux': csch,
        'arcsecaux': asec,
        'arccotaux': acot,
        'arccscaux': acsc,
        'arccoshaux': acosh,
        'arcsinhaux': asinh,
        'arctanhaux': atanh,
        'arcsechaux': asech,
        'arccschaux': acsch,
        'arccothaux': acoth,
        'sgnaux': sign,
    }
    for e in subs_dict:
        sympy_expr = sympy_expr.subs(Function(e), subs_dict[e])
    return sympy_expr
