#### Example for oregon dataset ###

from code import *

if __name__ == '__main__':
	# get oracle using graph 1 -> run on graph 2
	print('generating predictor')
	tri_by_edges_oracle = tri_by_edges_calculator('oregon/graph1.txt')
	# keep only 10% of edges to form oracle
	tri_by_edges_oracle = {k: v for k, v in sorted(tri_by_edges_oracle.items(), key=lambda item: -item[1])[:int(len(tri_by_edges_oracle)*0.1)]}
	truth = 15834.0 # true number of triangles in graph 2
	true_m = 21999 # true # of edges
	print('done')

	# set space
	space = 3000 
	print('space:', space)
	frac = 0.3  # .3 fraction of space for heavy edges
	heavy_space = int(frac * space)
	file = 'oregon/graph2.txt' # run on graph #2
	p_topk = (space - heavy_space) / (true_m - heavy_space) # set sampling prob in our alg 
	p_naive = space/true_m # use true # of edges to set sampling probability for MVV
	alg_error = 0.0
	mvv_error = 0.0
	print('running experiment - 50 trials')
	# average error over 20 trials
	for t in range(50):
		alg_error += (abs(oracle_with_replacement_topk(file, p_topk, space, heavy_space, tri_by_edges_oracle)[0] - truth)/truth)/50.0
		mvv_error += (abs(sample_naive_faster(file, p_naive)[0] - truth)/truth)/50.0

	print('Printing relative error')
	print('MVV error:', round(mvv_error, 2), 'Our error:', round(alg_error, 2))