import frozenind

import os.path

def generate_orderfile(eps, N):
    print("Forming subchannel order file for eps = " + str(eps) + "...")
    file_name = "indices_" + str(N) + "ep" + str(eps) + ".txt"
    directory = "subchannel_rankings"
    
    if not os.path.isfile(os.path.join(directory, file_name)):
        in_order_inds = frozenind.all_inds_inorder(N=N, epsilon=eps, mu=4)
        with open(os.path.join(directory, file_name),"w") as f:
            for elem in in_order_inds:
                f.write(f"{elem}\n")

def generate_orderfile_goodonly(eps, N, T):
    # print("Forming subchannel order file for eps = " + str(eps) + "...")
    file_name = "goodindices_" + str(N) + "ep" + str(eps) + "thresh" + str(T) + ".txt"
    directory = "subchannel_rankings_newscheme"

    if not os.path.isfile(os.path.join(directory, file_name)):
        goodinds_inorder = frozenind.get_good_ind_inorder(N=N, epsilon=eps, mu=4, thresh=T)
        with open(os.path.join(directory, file_name),"w") as f:
            for elem in goodinds_inorder:
                f.write(f"{elem}\n")   