## Introduction


This is the official repo of the paper "Automated Filtering of Human Feedback Data for Aligning Text-to-Image Diffusion Models"


## Installation

To run FiFA, please create a Conda virtual environment and set it up using the requirements file as follows:

```bash
pip install -r requirements.txt
```

## Dataset

We primarily use the [Pick-a-Pic v2 dataset](yuvalkirstain/pickapic_v2), which is available on Hugging Face, for training a diffusion model. A path to the Hugging Face cache is specified in a training bash file. The data selected using FiFA among Pick-a-Pic v2 and [HPSv2 train sets](xswu/HPSv2) are available in `train_data` and are used for training the model in our main experiments. This selected data file, created using FiFA, consists of selected index numbers from the Pick-a-Pic v2 training set.

For the evaluation set, the manually filtered Pick-a-Pic v2 test dataset is located in the `qas_test_filtered.json` file inside the `test_data` folder. Evaluation prompts for other datasets, including PariPrompts and HPD v2 benchmark, are also included in the `test_data` folder.

## Training

You can train [SD1.5](https://huggingface.co/runwayml/stable-diffusion-v1-5) and [SDXL](https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0) models on the Pick-a-Pic v2 human feedback dataset using `bash_train.sh` and `bash_train_sdxl.sh`, respectively. To use the full dataset, set the `train_data_file` argument to an empty string. To use a subset of the data, including subsets filtered using FiFA, set `train_data_file` to the path of the file that contains the indexes of each data point. The index refers to the `__index_level_0__` attribute for Pick-a-Pic v2 dataset and list index for HPSv2 dataset.

Note that `train_data_file` should contain the word `pair` to filter based on image-caption pairs. If you want to filter based on specific captions, `train_data_file` should include `caption`, and the contents of the file should be a list of caption IDs.


### Important Arguments

- `--cache_dir`: path of cache directory for Pick-a-Pic dataset.
- `--train_file_list`: paths to json files that contain indexes of selected data.
- `--base_output_dir`: directory path to save logging files and model checkpoints.
- `--use_new_label_0`: the option that re-labels image pairs based on reward values.
- `--image_to_reward_path`: the path that contains reward value of each image. It is needed when doing re-labeling based on the reward values.
- `--resume_from_checkpoint`: the checkpoint step to resume your training (e.g. checkpoint-10000).
- `--checkpointing_steps`: how often to save model.

## Evaluation

You can evaluate pretrained or fine-tuned models on different benchmarks by setting the arguments in `bash_test.sh` and `bash_test_sdxl.sh`.

### Important Arguments

- `--reward_type`: the type of reward function.
- `--data_list`: suffixes of test prompt files for evaluation (e.g. _parti_test)
- `--pretrained_model_name_or_path`: the path of pretrained model (huggingface link).
- `--model_list`: the paths of checkpoints of fine-tuned diffusion models.
- `--output-dir`: the path to save evalution results (generated results and rewards)
- `--checkpoint_list`: the list of checkpoints of the model to evaluate. Should be empty to evaluate with pretrained model
- `--num_imgs_per_prompt`: the number of images to generate for each prompt.

<hr />

