#!/usr/bin/env python
# coding: utf-8

# In[10]:


import numpy as np
import pandas as pd
import sys, time, copy, time, random
import pickle as pkl
from sklearn import covariance
from sklearn.covariance import GraphicalLasso
import pandas as pd 
import numpy.linalg as LA
import networkx as nx
import cvxpy as cp
from numpy.linalg import norm as nm
from numpy.linalg import inv, pinv 
from scipy.stats import spearmanr
import warnings
warnings.filterwarnings('ignore')
from control import dare
import matplotlib.pyplot as plt 
import seaborn as sns 
from pandas.plotting import table  # EDIT: see deprecation warnings below
from matplotlib import cm
import matplotlib
name_conventions = {'er':'Erdos-Renyi', 'bara':'Barabasi-Albert', 'ws':'Watts-Strogatz'}
font = {'family' : 'normal','weight' : 'bold','size'   : 10}
matplotlib.rc('font', **font)


# In[2]:


def choose_graph(graph_mode,p):
    g = graph_mode
    if g == 'bara':
        #print(g,p)
        m = int(p)
        graph = nx.barabasi_albert_graph(n, m)
    elif g == 'er':
        p_er = p
        #print(g,p)
        graph = nx.erdos_renyi_graph(n, p_er, directed=True) 
    elif g == 'ws':
        k = int(p)
        #print(g,p)
        graph = nx.watts_strogatz_graph(n, k, p_ws)
    return graph

def choose_graph1(graph_mode):
    g = graph_mode
    if g == 'bara':
        graph = nx.barabasi_albert_graph(n, m)
    elif g == 'er':
        graph = nx.erdos_renyi_graph(n, p_er, directed=True) 
    elif g == 'ws':
        graph = nx.watts_strogatz_graph(n, k, p_ws)
    return graph

def weighted_matrix(n):
    sign = np.random.choice([-1,1],size = (n,n))
    W = np.multiply(sign,np.random.randint(low = 1, high = 5, size = (n,n)))
    return W

def action_series(noise_level, graph, flag_m, T):
    n = graph.number_of_nodes()
    A = nx.adjacency_matrix(graph).todense()
    W = weighted_matrix(n)
    G = np.multiply(W,A)
    spectral_radius = np.max([np.abs(i) for i in np.linalg.eigvals(G)])
    G = G.T/(spectral_radius+0.01)
    # generate alpha
    alpha_cov = np.identity(n)
    alpha_com = 10*np.random.multivariate_normal(mean = np.zeros(n), cov = alpha_cov)

    # generate u n*T
    u_cov = np.identity(n) # Sw
    U_com = np.random.multivariate_normal(mean = np.zeros(n), cov = u_cov, size = T).reshape(T, n)
    
    # generate x0
    x0_cov = np.identity(n) # Sw
    x0_com = 10*np.random.multivariate_normal(mean = np.zeros(n), cov = x0_cov)
    # generate x series n*(T+1)
    X_com = np.zeros((T+1,n))
    X_com[0] = x0_com
    
    noise = noise_level * np.random.multivariate_normal(mean = np.zeros(n), cov = np.identity(n), size = T).reshape(T, n)
    for i in range(T):
        X_com[i+1] = alpha_com + X_com[i]@G.T + U_com[i]*flag_m + noise[i]
    X_com = X_com.T
    U_com = U_com.T
    return X_com, U_com, alpha_com, G, u_cov

def Y_Z_V_series(X_com, U_com):
    n, m = X_com.shape
    X_com = X_com.T
    U_com = U_com.T
    Y_com = np.zeros((m-2, n))
    Z_com = np.zeros((m-2, n))
    V_com = np.zeros((m-2, n))
    #noise = noise_level * np.random.multivariate_normal(mean = np.zeros(n), cov = np.identity(n), size = m-1).reshape(m-1, n)
    for i in range(m-2):
        Y_com[i] = X_com[i+1] - X_com[i] #+ noise[i]
        Z_com[i] = X_com[i+2] - X_com[i+1] #+ noise[i+1]
        V_com[i] = U_com[i+1] - U_com[i]
    Y_com = Y_com.T
    Z_com = Z_com.T
    V_com = V_com.T
    return Y_com, Z_com, V_com


# # SSSI

# In[3]:


def learning_graph_1(theta, Y_com, Z_com, V_com, B, G_truth, u_cov):
    G = cp.Variable((n,n),name = 'G')
    obj = cp.Minimize(0.5*cp.norm(Z_com - G@Y_com - B*V_com,'fro')**2 + theta*cp.pnorm(G, 1))
    prob = cp.Problem(obj)
    prob.solve()
    G_learn_1 = G.value
    K, G_stable = project2stable(G_learn_1, u_cov)
    relative_error = np.linalg.norm(G_stable - G_truth,'fro')/np.linalg.norm(G_truth,'fro')
    return relative_error

def project2stable(G_learn, u_cov):
    delta = 0.00000001
    Q = np.identity(n)
    X, L, K = dare(G_learn, np.identity(n), Q, inv(2*delta*u_cov)) 
    return K, G_learn - K


# # SLS

# In[4]:


def least_square(Y_com, Z_com, V_com, B, G_truth, u_cov):
    G_ls = (Z_com - B*V_com)@Y_com.T @ pinv(Y_com@Y_com.T)
    K, G_stable = project2stable(G_ls, u_cov)
    relative_error = np.linalg.norm(G_stable - G_truth,'fro')/np.linalg.norm(G_truth,'fro')
    return relative_error


# # SL2LS

# In[5]:


def l2_norm(theta, Y_com, Z_com, V_com, B, G_truth, u_cov):
    G = cp.Variable((n,n),name = 'G')
    obj = cp.Minimize(0.5*cp.norm(Z_com - G@Y_com - B*V_com,'fro')**2 + theta*cp.norm(G, 'fro')**2)
    prob = cp.Problem(obj)
    prob.solve()
    G_l2 = G.value
    K, G_stable = project2stable(G_l2, u_cov)
    relative_error = np.linalg.norm(G_stable - G_truth,'fro')/np.linalg.norm(G_truth,'fro')
    return relative_error


# # Noise Level

# In[6]:


n = 100
T = 40
num_simulations = 50
noise_levels = [0.05,0.1,0.15,0.2,0.25,0.3]
flag_m = np.random.choice([0,1],size = n)
B = flag_m.reshape(n,1) @ np.ones((1,T-1))
graph_modes = ['er','ws','bara']

#0.0979591836734694
# theta_l2_norm = {'er': 1.495,'ws':0.759,'bara':1.806}
# theta_learn1 = {'er': 0.0118,'ws':0.0143,'bara':0.0133}
#0.00125

theta_l2_norm = {'er': 0.098,'ws':0.098,'bara':0.098}
theta_learn1 = {'er': 0.00125,'ws':0.00125,'bara':0.00125}

#ER 
p_er = 0.1

# WS
p_ws = 0.2
k = 5

# BA
m = 2

# df_graph = []
# df_error = []
# df_method = []
# df_noise = []
# parameter = {'er': 'p', 'ws':'k', 'bara':'m'}
# p_value = {'er': p_er, 'ws': k, 'bara': m}



for graph_mode in graph_modes:
    df_graph = []
    df_error = []
    df_method = []
    df_noise = []
    for noise_level in noise_levels:
        cnt = 0
        while cnt < num_simulations:
            graph = choose_graph1(graph_mode)
            X_com, U_com, alpha_com, G_truth, u_cov = action_series(noise_level, graph, flag_m, T)
            Y_com, Z_com, V_com = Y_Z_V_series(X_com, U_com)
            learn1_theta = theta_learn1[graph_mode]
            learn1_error = learning_graph_1(learn1_theta, Y_com, Z_com, V_com, B, G_truth, u_cov)
            df_graph.append(graph_mode)
            df_noise.append(noise_level)
            df_error.append(learn1_error)
            df_method.append('SSSI')
            print('Noise level ', noise_level,' cnt: ',cnt,' Relative Error of Algorithm 1: ',learn1_error)
            
            ls_error = least_square(Y_com, Z_com, V_com, B, G_truth, u_cov)
            df_graph.append(graph_mode)
            df_noise.append(noise_level)
            df_error.append(ls_error)
            df_method.append('SLS')
            print('Noise level ', noise_level,' cnt: ',cnt,' Relative Error of Stablized least square: ',ls_error)
            
            l2_norm_theta = theta_l2_norm[graph_mode]
            l2_norm_error = l2_norm(l2_norm_theta, Y_com, Z_com, V_com, B, G_truth, u_cov)
            df_graph.append(graph_mode)
            df_noise.append(noise_level)
            df_error.append(l2_norm_error)
            df_method.append('SL2LS')
            print('Noise level ', noise_level,' cnt: ',cnt,' Relative Error of Stablized L2 norm: ',l2_norm_error)

            cnt = cnt +1
    print(len(df_graph),len(df_noise),len(df_error),len(df_method)) 
    columns = {'graph':df_graph, 'noise level':df_noise, 'error':df_error,'method':df_method}
    df_performance = pd.DataFrame(columns)
    df_performance.to_csv('./noise_performance_{}.csv'.format(graph_mode))


# # Time Step

# In[7]:


n = 100
time_steps = [15,20,25,30,35,40]
num_simulations = 50
noise_level = 0.1

graph_modes = ['er','ws','bara']

#ER 
p_er = 0.1

# WS
p_ws = 0.2
k = 5

# BA
m = 2

theta_l2_norm = {'er': 0.098,'ws':0.098,'bara':0.098}
theta_learn1 = {'er': 0.00125,'ws':0.00125,'bara':0.00125}

# theta_l2_norm = {'er': 1.495,'ws':0.759,'bara':1.806}
# theta_learn1 = {'er': 0.0118,'ws':0.0143,'bara':0.0133}



graph_mode = graph_modes[1]

for graph_mode in graph_modes:
    df_graph = []
    df_error = []
    df_method = []
    df_T = []
    for T in time_steps:
        flag_m = np.random.choice([0,1],size = n)
        B = flag_m.reshape(n,1) @ np.ones((1,T-1))
        cnt = 0
        while cnt < num_simulations:
            graph = choose_graph1(graph_mode)
            X_com, U_com, alpha_com, G_truth, u_cov = action_series(noise_level, graph, flag_m, T)
            Y_com, Z_com, V_com = Y_Z_V_series(X_com, U_com)
            learn1_theta = theta_learn1[graph_mode]
            learn1_error = learning_graph_1(learn1_theta, Y_com, Z_com, V_com, B, G_truth, u_cov)
            df_graph.append(graph_mode)
            df_T.append(T)
            df_error.append(learn1_error)
            df_method.append('SSSI')
            print('T: ', T,' cnt: ',cnt,' Relative Error of Algorithm 1: ',learn1_error)
            
            ls_error = least_square(Y_com, Z_com, V_com, B, G_truth, u_cov)
            df_graph.append(graph_mode)
            df_T.append(T)
            df_error.append(ls_error)
            df_method.append('SLS')
            print('T: ', T,' cnt: ',cnt,' Relative Error of Stablized least square: ',ls_error)
            
            l2_norm_theta = theta_l2_norm[graph_mode]
            l2_norm_error = l2_norm(l2_norm_theta, Y_com, Z_com, V_com, B, G_truth, u_cov)
            df_graph.append(graph_mode)
            df_T.append(T)
            df_error.append(l2_norm_error)
            df_method.append('SL2LS')
            print('T: ', T,' cnt: ',cnt,' Relative Error of Stablized L2 norm: ',l2_norm_error)

            cnt = cnt +1
    print(len(df_graph),len(df_T),len(df_error),len(df_method)) 
    columns = {'graph':df_graph, 'T':df_T, 'error':df_error,'method':df_method}
    df_performance = pd.DataFrame(columns)
    df_performance.to_csv('./T_performance_{}.csv'.format(graph_mode))



# In[8]:


def plotting_function(pt, g):
    dd = pd.read_csv('./'+pt+'_performance_'+g+'.csv')
    x_name = dd.loc[1][1]
    
    plt.figure(figsize=(6,5))
    x_name = dd.columns[2]
    bp = sns.boxplot(x=x_name,y='error',data=dd,hue='method', showfliers=False,showmeans = False, palette=sns.color_palette("tab10"),linewidth=1)
    plt.title(name_conventions[g], fontsize = 20, fontweight = 'bold')
    plt.ylabel('Relative error', fontsize = 20, fontweight = 'bold')
    plt.ylim(0,1)
    plt.legend(loc = 3, prop={'size': 13}) # loc = 3/4
    #plt.xticks(range(4), [0.2, 0.4, 0.6, 0.8])
    plt.xlabel(x_name, fontsize = 20, fontweight = 'bold')      
    plt.tight_layout()
    plt.savefig('./'+pt + '_performance_{}.png'.format(g),dpi=150)
        


# In[9]:


for g in graph_modes:
        plotting_function('T',g)


# In[ ]:




