A template README.md for code accompanying the paper

# Functional Wasserstein Variational Policy Optimization

This repository is the official implementation of [Functional Wasserstein Variational Policy Optimization]. 

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## Figure 1 in the paper

To obtain the figure 1 in the paper, run the command:

```
python fit_gmm3.py
```

## Training

To train the model(s) in the paper, run the commands:

```
python ppo/train2-humanoid.py
python fkppo/train2-humanoid.py
python fwppo/train-humanoid.py
```

To train the model(s) under noisy environments, run:

```
python ppo/train2-humanoid-noise.py
python fkppo/train2-humanoid-noise.py
python fwppo/train-humanoid-noise.py
```

The log and pretrained-model will be saved in the respective folders regularly.  


## Environment variations

When doing the generalization experiments, please download gym (from https://github.com/openai/gym) instead of installing it, then making the changes as given in Supplementary. Then, run the command:

```
python generalization_test_mujoco.py
python generalization_test_mujoco_ppo.py
```




