# MaPLe: Multi-modal Prompt Learning 

## Evaluation (base-to-novel class generalization)
We provide evaluation code with pre-computed predictions for reproducing our base-to-novel class generalization results in Table 2 of the paper.

## Installation
This codebase is tested on Ubuntu 20.04.2 LTS with python 3.8. Follow the below steps to create environment and install dependencies.

```shell
conda create -y -n maple_eval python=3.8
conda activate maple_eval
pip install -U scikit-learn
```

## Reproduce Results for Single Dataset
Run the following command to reproduce our individual dataset results for base-to-novel class generalization in Table 2 of the paper. Note that we do not provide the pre-computed predictions for ImageNet because of the size limit.
```shell
# Compute accuracies for base and novel classes for a dataset averaged over 3 seeds.
# Possible dataset values includes [caltech101, food101, dtd, ucf101, oxford_flowers, oxford_pets, fgvc_aircraft, stanford_cars, sun397, eurosat]
python main.py --logits_path ./inference_embeddings --dataset_name caltech101
```
This should reproduce and print out base and novel accuracies for given dataset as below:

```
   Evaluating pre-computed predictions...
   Base class accuracy averaged over 3 seeds for caltech101 is 97.74%
   Novel class accuracy averaged over 3 seeds for caltech101 is 94.36%
```


## Reproduce Results for all Datasets together
Run the following command to reproduce our all dataset results for base-to-novel class generalization in Table 2 of the paper.
```shell
# Compute accuracies for base and novel classes for all datasets averaged over 3 seeds.
sh ./eval_all.sh "./inference_embeddings/"
```
This should reproduce and print out base and novel accuracies of 10/11 datasets in Table 2 of the paper. 

