import argparse
from eval import evaluate_results


def parse_arguments():
    """
    Parse the command line arguments
    """
    ap = argparse.ArgumentParser()
    ap.add_argument("-predictions", "--logits_path", required=False,
                    default="./inference_embeddings/",
                    help="The path to the stored pre-computed predictions")
    ap.add_argument("-dataset", "--dataset_name", required=False,
                    default="dtd",
                    help="Name of the dataset")

    args = vars(ap.parse_args())

    return args


def main(args):
    # First obtain base class results
    main_path = args["logits_path"]
    base_class = '/base_classes/train_base/'
    novel_class = '/novel_classes/test_new/'
    common_path = 'shots_16/CoCoOp/vit_b16_c4_ep10_batch1_ctxv1/'
    base_class_path = main_path + base_class + args["dataset_name"] + '/' + common_path
    novel_class_path = main_path + novel_class + args["dataset_name"] + '/' + common_path
    print("Evaluating pre-computed predictions...")
    results1 = evaluate_results(args["dataset_name"], base_class_path, class_type='Base')
    # Next, obtain novel class results
    results2 = evaluate_results(args["dataset_name"], novel_class_path, class_type='Novel')
    print('---------')


if __name__ == "__main__":
    args = parse_arguments()
    main(args)
