import os
import glob
import sys
import random

import torch
import torch.multiprocessing as mp
import numpy as np
from absl import logging
import wandb

from mllmsd.config import ex
from mllmsd.utils.util import set_seed   
from trainer import Trainer

from huggingface_hub import login

@ex.automain
def main(_config):
	# Set seed, and checkpoint name
	set_seed(_config['seed'])
	login("XXXX-1")

	trainer = Trainer(_config)

	if not _config['test_only']:
		trainer.train() # train, save, test
	else:
		trainer.test() # test
	
	if not _config['debug']:
		wandb.finish(0)