exp_title="fp16-single-drf-caption-A6000-SQA-240925"
drfs="XXXX-2/lvlm68m"
tgts="llava-hf/llava-1.5-7b-hf"
eval_model="EvalLvlm" # align with drfs, tgts
draftings="CaptionDraft"
eval_drafting="caption" # align with draftings
caption_types="<CAPTION> <MORE_DETAILED_CAPTION>"
captioning_models="microsoft/Florence-2-large-ft"
WholeData="Dc100Data VibeEvalData SpotTheDiffData BirdsToWordsData ClevrChangeData IEditData FlintstonesSVData VISTData WebQAData LlavaBenchInTheWildData AESOPData PororoSVData LiveBenchData"
eval_datasets="DC100_EN,VibeEval,Spot-the-Diff,Birds-to-Words,CLEVR-Change,IEdit,FlintstonesSV,VIST,WebQA,llava-bench-in-the-wild,AESOP,PororoSV,LiveBench"
for drf in $drfs
do
    for tgt in $tgts
    do
        for dataset in $WholeData
        do
            for drafting in $draftings
            do
                for caption_type in $caption_types
                do
                    for captioning_model in $captioning_models
                    do
                    OMP_NUM_THREADS=4 NUMEXPR_MAX_THREADS=4 CUDA_VISIBLE_DEVICES=1 \
                        python3 main.py with SpecDecoding HalfPrecision $dataset \
                        drf=$drf tgt=$tgt \
                        $drafting \
                        caption_type=$caption_type captioning_model=$captioning_model \
                        exp_title=$exp_title ;
                    done
                done
            done
        done
    done
done
eval_caption_type=$(echo $caption_types | sed 's/ /,/g')
eval_captioning_model=$(echo $captioning_models | sed 's/ /,/g')
eval_drafting=$(echo $eval_drafting | sed 's/ /,/g')
python3 mllmsd/utils/evaluation.py with EvaluationSD \
    exp_title=$exp_title \
    $eval_model \
    eval_drafting=$eval_drafting \
    eval_datasets=$eval_datasets \
    eval_caption_type=$eval_caption_type \
    eval_captioning_model=$eval_captioning_model ;

csv_dir="/XXXX-5/home-XXXX-3/data/MSD/csv"
git_dir="/XXXX-5/home-XXXX-3/data/MSD/MLLMSD_Results"
cp -r "$csv_dir/$exp_title" "$git_dir/$exp_title"
