import os
import numpy as np
import logging
from typing import Dict

class Saver:
    def __init__(self, _config: Dict, ckpt_save):
        self.npy_save_dir = f"{_config['root']}/data/MSD/npy/{_config['exp_title']}/{ckpt_save}"
        os.makedirs(self.npy_save_dir, exist_ok=True)

    def save_metrics(self, criterion, step: int):
        filename = "config.npy"
        npy_path = os.path.join(self.npy_save_dir, filename)
        self._save_npy(npy_path, 'config', criterion._config)

        # save metrics
        for key, value in criterion.metrics.items():
            filename = f"{key}_{step:05d}.npy" if step is not None else f"{key}.npy"
            npy_path = os.path.join(self.npy_save_dir, filename)
            self._save_npy(npy_path, key, value)
    
    def _save_npy(self, npy_path, key, value):
        np.save(npy_path, np.array(value, dtype=object))
        logging.info(f"[Saver] Save {key} to {npy_path} ...")