exp_title="fp16-cascade-MTC-A6000-SQA-240925"
drfs="XXXX-2/lvlm68m"
tgts="llava-hf/llava-1.5-7b-hf"
eval_model="EvalLvlm" # align with drfs, tgts
draftings="CascadeMTC"
eval_drafting="EvalCascadeMTC" # align with draftings
caption_types="<CAPTION> <MORE_DETAILED_CAPTION>"
captioning_models="microsoft/Florence-2-large-ft"
cascade_rules="mm-weight"
mm_weight_policys="1 2 3 4"
WholeData="Dc100Data VibeEvalData SpotTheDiffData BirdsToWordsData ClevrChangeData IEditData FlintstonesSVData VISTData WebQAData LlavaBenchInTheWildData AESOPData PororoSVData LiveBenchData ScienceQAData"
eval_datasets="DC100_EN,VibeEval,Spot-the-Diff,Birds-to-Words,CLEVR-Change,IEdit,FlintstonesSV,VIST,WebQA,llava-bench-in-the-wild,AESOP,PororoSV,LiveBench,ScienceQA"
for drf in $drfs
do
    for tgt in $tgts
    do
        for dataset in $WholeData
        do
            for drafting in $draftings
            do
                for caption_type in $caption_types
                do
                    for captioning_model in $captioning_models
                    do
                        for cascade_rule in $cascade_rules
                        do
                            for mm_weight_policy in $mm_weight_policys
                            do
                                OMP_NUM_THREADS=4 NUMEXPR_MAX_THREADS=4 CUDA_VISIBLE_DEVICES=1 \
                                    python3 main.py with SpecDecoding HalfPrecision $dataset \
                                    drf=$drf tgt=$tgt \
                                    $drafting \
                                    cascade_rule=$cascade_rule mm_weight_policy=$mm_weight_policy \
                                    caption_type=$caption_type captioning_model=$captioning_model \
                                    exp_title=$exp_title ;
                            done
                        done
                    done
                done
            done
        done
    done
done
eval_cascade_rule=$(echo $cascade_rules | sed 's/ /,/g')
eval_mm_weight_policy=$(echo $mm_weight_policys | sed 's/ /,/g')
eval_caption_type=$(echo $caption_types | sed 's/ /,/g')
eval_captioning_model=$(echo $captioning_models | sed 's/ /,/g')
eval_drafting=$(echo $eval_drafting | sed 's/ /,/g')
python3 mllmsd/utils/evaluation.py with EvaluationSD \
    exp_title=$exp_title \
    $eval_model \
    $eval_drafting \
    eval_datasets=$eval_datasets \
    eval_caption_type=$eval_caption_type \
    eval_captioning_model=$eval_captioning_model \
    eval_cascade_rule=$eval_cascade_rule \
    eval_mm_weight_policy=$eval_mm_weight_policy ;

csv_dir="/XXXX-5/home-XXXX-3/data/MSD/csv"
git_dir="/XXXX-5/home-XXXX-3/data/MSD/MLLMSD_Results"
cp -r "$csv_dir/$exp_title" "$git_dir/$exp_title"