import math
import types
from typing import Optional, Tuple

import torch
import torch.nn as nn
from transformers.models.llama.modeling_llama import apply_rotary_pos_emb



def llama_head_guide(model, aggregation = None, alpha = None, beta = None, img_start_idx = None, img_end_idx = None,sink_tokens = None, guided_layer_list = None,head_list = None):
    
    if head_list is None and guided_layer_list is not None:
        for i in guided_layer_list:
            model.layers[i].self_attn.img_start_idx = img_start_idx
            model.layers[i].self_attn.img_end_idx = img_end_idx
            model.layers[i].self_attn.aggregation = aggregation
            model.layers[i].self_attn.alpha = alpha
            model.layers[i].self_attn.sink_tokens = sink_tokens
            model.layers[i].self_attn.forward = types.MethodType(llama_new_forward_sink, model.layers[i].self_attn)
    elif head_list is not None:
        for i in range(32):
            model.layers[i].self_attn.img_start_idx = img_start_idx
            model.layers[i].self_attn.img_end_idx = img_end_idx
            model.layers[i].self_attn.aggregation = aggregation
            model.layers[i].self_attn.alpha = alpha
            model.layers[i].self_attn.beta = beta
            model.layers[i].self_attn.sink_tokens = sink_tokens
            model.layers[i].self_attn.head_list = head_list[i]
            model.layers[i].self_attn.forward = types.MethodType(llama_new_forward_sink, model.layers[i].self_attn)
            
        


def llama_new_forward_sink(
    self,
    hidden_states: torch.Tensor,
    attention_mask: Optional[torch.Tensor] = None,
    position_ids: Optional[torch.LongTensor] = None,
    past_key_value: Optional[Tuple[torch.Tensor]] = None,
    output_attentions: bool = False,
    use_cache: bool = False,
) -> Tuple[torch.Tensor, Optional[torch.Tensor], Optional[Tuple[torch.Tensor]]]:
    bsz, q_len, _ = hidden_states.size()

    query_states = (
        self.q_proj(hidden_states)
        .view(bsz, q_len, self.num_heads, self.head_dim)
        .transpose(1, 2)
    )
    key_states = (
        self.k_proj(hidden_states)
        .view(bsz, q_len, self.num_heads, self.head_dim)
        .transpose(1, 2)
    )
    value_states = (
        self.v_proj(hidden_states)
        .view(bsz, q_len, self.num_heads, self.head_dim)
        .transpose(1, 2)
    )

    kv_seq_len = key_states.shape[-2]
    if past_key_value is not None:
        if self.layer_idx is None:
            raise ValueError(
                f"The cache structure has changed since version v4.36. If you are using {self.__class__.__name__} "
                "for auto-regressive decoding with k/v caching, please make sure to initialize the attention class "
                "with a layer index."
            )
        kv_seq_len += past_key_value.get_usable_length(kv_seq_len, self.layer_idx)
    cos, sin = self.rotary_emb(value_states, seq_len=kv_seq_len)
    query_states, key_states = apply_rotary_pos_emb(
        query_states, key_states, cos, sin, position_ids
    )

    if past_key_value is not None:
        cache_kwargs = {"sin": sin, "cos": cos}  # Specific to RoPE models
        key_states, value_states = past_key_value.update(
            key_states, value_states, self.layer_idx, cache_kwargs
        )

    attn_weights = torch.matmul(query_states, key_states.transpose(2, 3)) / math.sqrt(
        self.head_dim
    )

    if attn_weights.size() != (bsz, self.num_heads, q_len, kv_seq_len):
        raise ValueError(
            f"Attention weights should be of size {(bsz, self.num_heads, q_len, kv_seq_len)}, but is"
            f" {attn_weights.size()}"
        )

    if attention_mask is not None:
        if attention_mask.size() != (bsz, 1, q_len, kv_seq_len):
            raise ValueError(
                f"Attention mask should be of size {(bsz, 1, q_len, kv_seq_len)}, but is {attention_mask.size()}"
            )
        attn_weights = attn_weights + attention_mask
        attn_weights = torch.max(
            attn_weights, torch.tensor(torch.finfo(attn_weights.dtype).min)
        )

    ### vision attention modification
    if hasattr(self, "aggregation") and self.aggregation is not None:
        img_start_idx = self.img_start_idx
        img_end_idx = self.img_end_idx
        aggregation = self.aggregation

        
        sink_tokens = self.sink_tokens
        if aggregation == "mean":
            attn_weights[:, :, -1, img_start_idx:img_end_idx] = (
                attn_weights[:, :, -1, img_start_idx:img_end_idx]
                + self.alpha * attn_weights[:, :, -1, img_start_idx:img_end_idx].abs().mean(dim=1, keepdim=True)
            )
        elif "sink" in aggregation:
            # attn_weights: [B, H, seq_len, seq_len]
            head_list = self.head_list

            head_mask = torch.zeros(attn_weights.shape[1], dtype=torch.bool, device=attn_weights.device)
            head_mask[head_list] = True
            head_mask = head_mask.view(1, -1, 1, 1)  # [1, H, 1, 1]


            device = attn_weights.device
            num_img_tokens = img_end_idx - img_start_idx  # e.g. 576
            

            sink_mask = torch.zeros(num_img_tokens, dtype=torch.bool, device=device)
            sink_mask[sink_tokens] = True  


            increase_mask = (~sink_mask).unsqueeze(0).unsqueeze(0)  
            decrease_mask = sink_mask.unsqueeze(0).unsqueeze(0)     
            
            slice_vis = attn_weights[:, :, -1, img_start_idx:img_end_idx]  # [B, H, T]
   
            ### mean
            adjustment = self.alpha * slice_vis.abs()  # [B, 1, T]
            
            adjustment_sub =  self.beta * slice_vis.abs().mean(dim=1, keepdim=True)
            
            slice_vis = slice_vis + adjustment * head_mask.squeeze(-1) \
                - adjustment_sub * decrease_mask  # [B, H, T]

            slice_vis = slice_vis + adjustment * head_mask.squeeze(-1) * increase_mask  # [B, H, T]

            attn_weights[:, :, -1, img_start_idx:img_end_idx] = slice_vis

    ### vision attention modification

    attn_weights = nn.functional.softmax(attn_weights, dim=-1, dtype=torch.float32).to(
        query_states.dtype
    )

    attn_output = torch.matmul(attn_weights, value_states)

    if attn_output.size() != (bsz, self.num_heads, q_len, self.head_dim):
        raise ValueError(
            f"`attn_output` should be of size {(bsz, self.num_heads, q_len, self.head_dim)}, but is"
            f" {attn_output.size()}"
        )

    attn_output = attn_output.transpose(1, 2)
    attn_output = attn_output.reshape(bsz, q_len, self.hidden_size)

    attn_output = self.o_proj(attn_output)

    if not output_attentions:
        attn_weights = None

    return attn_output, attn_weights, past_key_value
