# Supplementary Material for ICLR 2026 Submission

## Overview

This supplementary material provides the core implementation details for the methods proposed in our paper, "Sink-Aware Visual Attention Enhancement for Large Vision-Language Models". We include two key files that are central to our contributions: the framework for identifying Visual Attention Sink (VAS) tokens (**VFI**), and the attention enhancement mechanism itself (**SAVAE**).

The purpose of this material is to facilitate the review process by offering a transparent look at our core algorithms and to ensure the reproducibility of our work.

## Code Description

The supplementary material contains the following two files:

* `VFI.ipynb`
    * This Jupyter Notebook contains the core implementation of our **Vocabulary Fixation-Based Identification (VFI)** framework, as described in Section 3 of the main paper.
* `attention.py`
    * This Python script contains the core implementation of our **Sink-Aware Visual Attention Enhancement (SAVAE)** method, as described in Section 4 of the main paper.

## Note on Reproducibility

Please note that these files are provided to illustrate the core logic of our proposed methods. The full, executable codebase, along with all scripts required to reproduce the experiments presented in the paper, will be made publicly available under an MIT license upon the paper's acceptance.
