### Training
#### Single Task (UFO-ViT-B)
Detection

```shell
bash tools/dist_train.sh configs/UFO-ViT/single_detection_base.py  ${GPU_NUM} --work-dir ${work_dir}
```

Semantic Segmentation

```shell
bash tools/dist_train.sh configs/UFO-ViT/single_semseg_base.py  ${GPU_NUM} --work-dir ${work_dir}
```

Instance Segmentation

```shell
bash tools/dist_train.sh configs/UFO-ViT/single_insseg_base.py  ${GPU_NUM} --work-dir ${work_dir}
```

Image Caption

```shell
bash tools/dist_train.sh configs/UFO-ViT/single_caption_base.py  ${GPU_NUM} --work-dir ${work_dir}
```

Visual Grounding

```shell
bash tools/dist_train.sh configs/UFO-ViT/single_ground_base.py ${GPU_NUM} --work-dir ${work_dir}
```

#### Multi Task (UFO-ViT)

UFO-ViT-B

```shell
bash tools/dist_train.sh configs/UFO-ViT/multi_fivetask_base.py  ${GPU_NUM} --work-dir ${work_dir}
```

UFO-ViT-L

```shell
bash tools/dist_train.sh configs/UFO-ViT/multi_fivetask_large.py ${GPU_NUM} --work-dir ${work_dir}
```

UFO-ViT-H

```shell
bash tools/dist_train.sh configs/UFO-ViT/multi_fivetask_huge.py ${GPU_NUM} --work-dir ${work_dir}
```

#### Multi Task (UFO-InternVL2.5-8B)
448x448

```shell
bash tools/dist_train.sh configs/UFO-InternVL2_5-8B-multitask/multi_448_30w.py  ${GPU_NUM} --work-dir ${work_dir}
```

896x896

```shell
bash tools/dist_train.sh configs/UFO-InternVL2_5-8B-multitask/multi_896_6w.py  ${GPU_NUM} --work-dir ${work_dir}
```

#### Instruction Tuning

UFO-InternVL2.5-8B

```shell
bash tools/dist_train.sh configs/UFO-InternVL2_5-8B/internvl2_8b_instruction_12w.py  ${GPU_NUM} --work-dir ${work_dir}
```

UFO-LLaVA-1.5-7B

```shell
bash tools/dist_train.sh configs/UFO-LLaVA1.5-7B/llava1.5_7b_instruction_12w.py ${GPU_NUM} --work-dir ${work_dir}
```

### Testing

#### Single Task (UFO-ViT-B)
Detection

```shell
bash tools/dist_test.sh configs/UFO-ViT/single_detection_base.py ${ckpt_file} ${GPU_NUM} --work-dir ${work_dir}
```

Semantic Segmentation

```shell
bash tools/dist_test.sh configs/UFO-ViT/single_semseg_base.py ${ckpt_file} ${GPU_NUM} --work-dir ${work_dir}
```

Instance Segmentation

```shell
bash tools/dist_test.sh configs/UFO-ViT/single_insseg_base.py ${ckpt_file} ${GPU_NUM} --work-dir ${work_dir}
```

Image Caption

```shell
bash tools/dist_test.sh configs/UFO-ViT/single_caption_base.py ${ckpt_file} ${GPU_NUM} --work-dir ${work_dir}
```

Visual Grounding

```shell
bash tools/dist_test.sh configs/UFO-ViT/single_ground_base.py ${ckpt_file} ${GPU_NUM} --work-dir ${work_dir}
```
 



