#!/bin/bash

exe() { echo "\$ $@" ; "$@" ; }

exe echo Training sparse-C-MAML with alpha=0.9

python3 main.py --dataset omniglot --cuda 0 --prob_statio 0.9 --model_name sparseMAML --learn_step_size True --per_param_step_size True --meta_lr 0.001 --batch_size 8 --step_size 0.1 --num_steps 16 --first_order True --mean_eta 10.0 --cl_strategy_thres 0.0 --cl_tbd_thres 1.0 --cl_accumulate False --num_epochs 0 --patience 20 --masks_init 0.4 --l1_reg 1.0 --step_size_activation binary_trough --alpha_0 0.3 --meta_lr_m 0.003

exe echo Training sparse-C-MAML with alpha=0.98

python3 main.py --dataset omniglot --prob_statio 0.98 --model_name sparseMAML --learn_step_size True --per_param_step_size True --meta_lr 0.001 --batch_size 8 --step_size 0.1 --num_steps 16 --first_order True --mean_eta 10.0 --cl_strategy_thres 0.0 --cl_tbd_thres 1.0 --cl_accumulate False --num_epochs 0 --patience 20 --masks_init 0.4 --l1_reg 10.0 --step_size_activation binary_trough --alpha_0 0.3 --meta_lr_m 0.01 --cuda 0 --meta_kaiming_init True

exe echo Training sparse-ReLU-C-MAML with alpha=0.9

python3 main.py --dataset omniglot --prob_statio 0.9 --model_name sparseMAML --learn_step_size True --per_param_step_size True --meta_lr 0.001 --batch_size 8 --step_size 0.1 --cuda 0 --num_steps 16 --first_order True --mean_eta 10.0 --cl_strategy_thres 0.0 --cl_tbd_thres 1.0 --cl_accumulate False --num_epochs 0 --patience 20 --masks_init 0.4 --l1_reg 1.0 --step_size_activation relu_trough --meta_lr_m 0.01 --meta_uniform_init True

exe echo Training sparse-ReLU-C-MAML with alpha=0.98

python3 main.py --dataset omniglot --cuda 0 --prob_statio 0.98 --model_name sparseMAML --learn_step_size True --per_param_step_size True --meta_lr 0.001 --batch_size 8 --step_size 0.1 --num_steps 16 --first_order True --mean_eta 10.0 --cl_strategy_thres 0.0 --cl_tbd_thres 1.0 --cl_accumulate False --num_epochs 0 --patience 20 --masks_init 0.4 --l1_reg 10.0 --alpha_0 0.1 --cuda 0 --step_size_activation relu_trough --meta_lr_m 0.01 --meta_uniform_init True 

