## Sparse-C-MAML code

## (key) Requirements 
- Python 3.6
- Pytorch 1.2 (there is a small bug with newer versions)
- Havenai 0.6 or higher (to reproduce the official results)

(Note that these requirements were set by the original authors - we had a little trouble installing the correct packages.)

`pip install -r requirements.txt`

## Structure

    ├── Config
        ├── model's configuration 
    ├── Data
        ├── omniglot.py           # fetches the dataset      
        ├── tiered_imagenet.py    # fetches the dataset
    ├── MAML           
        ├── metalearner
            ├── maml.py           # defines the models, in particular their CL strategy
        ├── model.py              # defines the backbone neural networks
        ├── utils.py              # some utils    
    ├── Utils
        ├── bgd_lib
            ├── ...         # files for BGD      
    ├── main_haven.py       # main file to reproduce results
    ├── main.py             # main file   
    ├── sweep.py            # hyper-parameter sweep
    ├── dataloaders.py      # defines the experiment setting, constructs the dataloaders    
    ├── args.py             # arguments
    ├── template.py         # main file template (if you dont want to use pytorch)
   
## Data download

Omniglot: automatic

## Running Experiments

To reproduce sparse-C-MAML, run first the following command:

```chmod +x run_experiments.sh```

You can run all the experiments (sparse-ReLU-C-MAML as well as sparse-C-MAML) for alpha=0.9 as wellas alpha=0.98 using the following command:

```
./run_experiments.sh
```

## Logging
Logging is done with [Weights & Biases](https://www.wandb.com/) and can be turned on like this: </br>
`python main.py --wandb <workspace_name>`


