# sparse La-MAML

This code is a clone from the original La-MAML codebase https://github.com/montrealrobotics/La-MAML/ and implements the simple sparse-La-MAML variant. 

To reproduce the results in the paper, please follow these instructions:

Download the mnist data:

```python get_data.py all```

Create a conda environment via

```conda env create -f environment.yml```

Once completed source your environment using:

```conda activate lamaml```

This will create a conda environment (an isolated workplace) with most of the files installed in it. The rest of the files can be installed using pip:

```pip install -r requirements.txt```

For the original La-MAML MNIST experiments and it's emergent sparsity, run first the following command:

```chmod +x run_experiments.sh```

Finally, you can run all the experiments using the following command:

```
./run_experiments.sh
```

For the sparse La-MAML MNIST experiments and it's emergent sparsity, run first the following command:

```chmod +x run_experiments_sparse.sh```

Finally, you can run all the experiments using the following command:

```./run_experiments_sparse.sh```


For the implementation of sparse-La-MAML, see the changes in the file model/lamaml.py.

