#!/bin/bash

ROT="--n_layers 2 --n_hiddens 100 --data_path data/ --log_every 100 --samples_per_task 1000 --dataset mnist_rotations    --cuda --log_dir logs/"
PERM="--n_layers 2 --n_hiddens 100 --data_path data/ --log_every 100 --samples_per_task 1000 --dataset mnist_permutations --cuda --log_dir logs/"
MANY="--n_layers 2 --n_hiddens 100 --data_path data/ --log_every 100 --samples_per_task 200 --dataset mnist_manypermutations --cuda --log_dir logs/"
CIFAR='--data_path data/ --log_every 100 --dataset cifar100 --cuda --log_dir logs/'
CIFAR10= '--data_path data/ --cuda --dataset cifar10 --cuda --log_dir logs/ '
IMGNET='--data_path data/tiny-imagenet-200/ --log_every 100 --dataset tinyimagenet --cuda --log_dir logs/'
SEED=0
exe() { echo "\$ $@" ; "$@" ; }

########## MNIST DATASETS ##########
##### sparse La-MAML #####

# ROTATION
#lamaml
exe echo Training sparse-La-MAML rotation
python3 main.py $ROT --model lamaml --memories 200 --batch_size 10 --replay_batch_size 10 --n_epochs 1 --glances 5 --opt_lr 1.7 \
                     --alpha_init 0.15 --learn_lr --use_old_task_memory --seed $SEED --sparsity
#PERMUTATION
#lamaml
exe echo Training sparse-La-MAML permutation
python3 main.py $PERM --model lamaml --memories 200 --batch_size 10 --replay_batch_size 10 --n_epochs 1 --glances 10 --opt_lr 1.7 \
                    --alpha_init 0.1 --learn_lr --use_old_task_memory --seed $SEED --sparsity

#MANY
#lamaml
exe echo Training sparse-La-MAML many
python3 main.py $MANY --model lamaml --memories 500 --batch_size 10 --replay_batch_size 10 --n_epochs 1 --glances 10 --opt_lr 0.75 \
	                    --alpha_init 0.05 --learn_lr --use_old_task_memory --seed $SEED --sparsity


# In order to increase the capacity fo the model, change the n_hidden:

exe echo Training sparse-La-MAML rotation with larger hidden layer
python3 main.py $ROT --model lamaml --memories 200 --batch_size 10 --replay_batch_size 10 --n_epochs 1 --glances 5 --opt_lr 1.7 \
	             --alpha_init 0.15 --learn_lr --use_old_task_memory --seed $SEED --sparsity --n_hidden 250

exe echo training sparse maml cifar 10
# Replay buffer of size 200
python3 train.py $CIFAR10 --cuda --dataset cifar10 --model lamaml --expt_name lamaml --memories 1000 --batch_size 10 --replay_batch_size 20 \
                  --n_epochs 1 --opt_lr 0.75 --alpha_init 0.005 --opt_wt 0.5 --glances 1 --loader class_incremental_loader --increment 2 --arch pc_cnn \
									--log_every 3125 --class_order random --calc_test_accuracy --validation 0.1 --grad_clip_norm 1.0 --second_order --cifar_batches 5 --learn_lr --seed $SEED --sparsity
# Replay buffer of size 1000
python3 train.py $CIFAR10 --cuda --dataset cifar10 --model lamaml --expt_name lamaml --memories 1000 --batch_size 10 --replay_batch_size 10 \
                  --n_epochs 1 --opt_lr 0.5 --alpha_init 0.01 --opt_wt 0.5 --glances 2 --loader class_incremental_loader --increment 2 --arch pc_cnn \
									--log_every 3125 --class_order random --calc_test_accuracy --validation 0.1 --grad_clip_norm 1.0 --second_order --cifar_batches 5 --learn_lr --seed $SEED --sparsity
