
#!/bin/bash

##### sparse La-MAML #####
exe() { echo "\$ $@" ; "$@" ; }

# 5-SHOT
exe echo training 5-SHOT sparse-MAML 
python3 /home/johannes/breaking-miniimagenet/train.py --x_output_shift=0.0 --epochs=350 --batches_train=100 --batches_test=300 --batches_val=300 --batch_size=2 --test_batch_size=1 --num_shots_test=15 --num_shots_train=5 --gradient_attention --init_shift=0.0 --seed=1 --step_size=0.25 --mask_lr=0.0075 --weight_noise=0.0 --checkpoint_models --gradient_steps=35 --val_start=100 --kaiming_init --optimizer_theta=ADAM --optimizer_mask=ADAM --tensorboard 

exe echo training 5-SHOT sparse-MAML+

python3 /home/johannes/breaking-miniimagenet/train.py --optimizer_mask=SGD --x_debug --epochs=600 --batches_train=100 --batches_test=300 --batches_val=300 --batch_size=2 --test_batch_size=1 --num_shots_test=15 --num_shots_train=5 --gradient_attention --init_shift=0.0 --seed=4 --x_output_shift=0.0 --step_size=0.1 --mask_lr=0.0075 --weight_noise=0.0 --checkpoint_models --gradient_steps=35 --embedding_noise=0.1 --val_start=100 --x_dep_masking --kaiming_init --optimizer_theta=SGD --tensorboard 

exe echo training 5-SHOT sparse-ReLU-MAML

python3 /home/johannes/breaking-miniimagenet/train.py --x_output_shift=0.0 --epochs=350 --batches_train=100 --batches_test=300 --batches_val=300 --batch_size=2 --test_batch_size=1 --num_shots_test=15 --num_shots_train=5 --gradient_attention --init_shift=0.0 --seed=1 --step_size=0.5 --mask_lr=0.005 --weight_noise=0.0 --checkpoint_models --gradient_steps=35 --val_start=100 --kaiming_init --optimizer_theta=ADAM --optimizer_mask=ADAM --tensorboard --meta_relu_through


# 1-SHOT

exe echo training 1-SHOT sparse-MAML 

python3 /home/johannes/breaking-miniimagenet/train.py --batch_size=4 --x_debug_noise=0.0 --x_output_shift=0.0 --checkpoint_models --epochs=350 --batches_train=100 --batches_test=300 --batches_val=300 --test_batch_size=1 --num_shots_test=15 --num_shots_train=1 --gradient_attention --init_shift=0.0 --seed=2 --step_size=0.1 --gradient_steps=35 --mask_lr=0.0075 --val_after=5 --val_start=100 --kaiming_init --optimizer_theta=ADAM --optimizer_mask=ADAM --tensorboard 

exe echo training 1-SHOT sparse-MAML+

python3 /home/johannes/breaking-miniimagenet/train.py --batch_size=4 --optimizer_theta=SGD --optimizer_mask=SGD --step_size=0.1 --epochs=600 --checkpoint_models --batches_train=100 --batches_test=300 --batches_val=300 --test_batch_size=1 --num_shots_test=15 --num_shots_train=1 --gradient_attention --init_shift=0.0 --seed=1 --gradient_steps=35 --mask_lr=0.0075 --x_dep_masking --x_debug --val_after=10 --val_start=200 --x_debug_noise=1.0 --kaiming_init --tensorboard

exe echo training 1-SHOT sparse-ReLU-MAML

python3 /home/johannes/breaking-miniimagenet/train.py --batch_size=4 --x_debug_noise=0.0 --x_output_shift=0.0 --checkpoint_models --epochs=350 --batches_train=100 --batches_test=300 --batches_val=300 --test_batch_size=1 --num_shots_test=15 --num_shots_train=1 --gradient_attention --init_shift=0.0 --seed=2 --step_size=0.1 --gradient_steps=35 --mask_lr=0.001 --val_after=5 --val_start=100 --kaiming_init --optimizer_theta=ADAM --optimizer_mask=ADAM --tensorboard --meta_relu_through

