import http from 'k6/http';
import { check } from 'k6';

export const options = {
  vus: 10,
  duration: '5s',
};

export default function () {
  const res = http.get('http://example-service.default.svc.cluster.local');
  check(res, {
    'status is 200': (r) => r.status === 200,
    'body contains Nginx': (r) => r.body.includes('Welcome to nginx!'),
  });
}