import os
import time
import argparse
from kubernetes import client, config
from unittest_base import K8sAPIBase

class TestPodRunningState(K8sAPIBase):
    def __init__(self):
        super().__init__()

    def check_pod_running_status(self, namespace, pod_name):
        try:
            pod = self.v1.read_namespaced_pod(name=pod_name, namespace=namespace)
            return pod.status.phase == 'Running'
        except client.exceptions.ApiException as e:
            print(f"Exception when calling CoreV1Api->read_namespaced_pod: {e}")
            return False

    def test_pod_running_state(self, duration):
        namespace = 'default'
        pod_name = 'example-pod'
        running_count = 0

        # Check the pod status for the specified duration
        for _ in range(duration):
            if self.check_pod_running_status(namespace, pod_name):
                running_count += 1
            time.sleep(1)

        # Calculate the percentage of time the pod was running
        running_percentage = (running_count / duration) * 100

        # Assert that the pod was running for at least 95% of the time
        assert running_percentage >= 95, f"Pod '{pod_name}' was not running for at least 95% of the time. Actual: {running_percentage}%"


def main():
    parser = argparse.ArgumentParser(description='Test if a Kubernetes Pod is running for at least 95% of the time.')
    parser.add_argument('--duration', type=int, default=60, help='Duration to check the pod status in seconds')
    args = parser.parse_args()

    test = TestPodRunningState()
    test.test_pod_running_state(args.duration)


if __name__ == '__main__':
    main()