import http from 'k6/http';
import { check } from 'k6';

export const options = {
  vus: 10,
  duration: '5s',
  thresholds: {
    // Adding a threshold to ensure that the percentage of failed HTTP requests is less than or equal to 0.01%
    'http_req_failed': ['rate<=0.01'],
  },
};

export default function () {
  const res = http.get('http://example-service.default.svc.cluster.local');
  check(res, {
    'status is 200': (r) => r.status === 200,
    'body contains Nginx': (r) => r.body.includes('Welcome to nginx!'),
  });
}