import os
import time
import argparse
from kubernetes import client, config
from unittest_base import K8sAPIBase

class TestDeploymentRunningState(K8sAPIBase):
    def __init__(self):
        super().__init__()

    def check_deployment_running_status(self, namespace, label_selector):
        try:
            pods = self.v1.list_namespaced_pod(namespace=namespace, label_selector=label_selector)
            running_pods = [pod for pod in pods.items if pod.status.phase == 'Running']
            return len(running_pods) == len(pods.items)
        except client.exceptions.ApiException as e:
            print(f"Exception when calling CoreV1Api->list_namespaced_pod: {e}")
            return False

    def test_deployment_running_state(self, duration):
        namespace = 'default'
        label_selector = 'app=example'
        running_count = 0

        # Check the deployment status for the specified duration
        for _ in range(duration):
            if self.check_deployment_running_status(namespace, label_selector):
                running_count += 1
            time.sleep(1)

        # Calculate the percentage of time the deployment was running
        running_percentage = (running_count / duration) * 100

        # Assert that the deployment was running for at least 95% of the time
        assert running_percentage >= 95, f"Deployment with label '{label_selector}' was not running for at least 95% of the time. Actual: {running_percentage}%"


def main():
    parser = argparse.ArgumentParser(description='Test if a Kubernetes Deployment is running for at least 95% of the time.')
    parser.add_argument('--duration', type=int, default=60, help='Duration to check the deployment status in seconds')
    args = parser.parse_args()

    test = TestDeploymentRunningState()
    test.test_deployment_running_state(args.duration)


if __name__ == '__main__':
    main()