# ChaosEater: Fully Automating Chaos Engineering with Larage Language Models 

<p>
  This repo is the official implementation of "ChaosEater: Automating Chaos Engineering with Larage Language Models". ChaosEater is an LLM-based system for automating the entire Chaos Engineering cycle, which consists of four phases: hypothesis, experiment, analysis, and improvement phases.
</p>

> [!WARNING]  
> This system is an experimental implementation and is not for product environments.

## 🚀 Quick Start
In the following, we assume that Docker has been already installed on your local environment (Ubuntu).  
FYI: Docker installation guide (official): https://docs.docker.com/engine/install/ubuntu/
### 0. Clone this repository
Clone this repository and move there.
```
git clone <this-repo> && cd <this-repo> 
```
### 1. Install environment
Install dependency tools in local using [create_environment.sh](./create_environment.sh). The installed tools include ```kubectl```, ```kind```, ```krew```, ```kubectl-graph```, ```skaffold```. Note that tools that are already installed in local will be skipped.
```
./create create_environment.sh
```
### 2. Create kind cluster
Create kind cluster using [create_kind_cluster.sh](./create_kind_cluster.sh). You may change the cluster name with the the ```-n,--name <your-favorite-name>``` option.
```
./create create_kind_cluster.sh
```

### 3. Launch ChoasEater GUI
Build a docker image for ChaosEater using [Dockerfile_llm](./docker/Dockerfile_llm).
```
docker build -f docker/Dockerfile_llm -t chaos-eater/chaos-eater:1.0 .
```
Then, run the docker container in interactive mode.
```
docker run -it --rm \
           -v .:/app/ \
           -v ~/.kube/config:/root/.kube/config \
           -v $(which kubectl):/usr/local/bin/kubectl \
           -v $(which skaffold):/usr/local/bin/skaffold \
           -v ~/.krew/bin/kubectl-graph:/root/.krew/bin/kubectl-graph \
           -e PATH="/root/.krew/bin:$PATH" \
           --name chaos-eater \
           --network host \
           chaos-eater/chaos-eater:1.0 bash
```
In the continer, set each API key (```Anthropic```, ```Gemini```, and ```OpenAI``` are supported) and launch the streamlit app of ChaosEater. You may change the server port of the app with the ```--server.port <port>``` option.
```
export ANTHROPIC_API_KEY=<your anthropic api key>
export GOOGLE_API_KEY=<your gemini api key>
export OPENAI_API_KEY=<your openai api key>
```
```
streamlit run ChaosEater_demo.py --server.fileWatcherType none
```
Access ```localhost:<port>``` in your browser. Now, you can try the ChaosEater GUI in your browser!  
If you are working on a remote server, don't forget to set up fort forwarding, e.g., ```ssh <remote-server> -L <port>:localhost:<port>```.  
