import streamlit as st
import streamlit.components.v1 as components

#----------------
# util functions
#----------------
def apply_html(html: str, **kwargs) -> None:
    st.markdown(html, unsafe_allow_html=True, **kwargs)


# ref: https://discuss.streamlit.io/t/st-logo-image-size/71085/3
REMOVE_SIDEBAR_TOPSPACE = """\
<style>
    div[data-testid="stSidebarHeader"] > img, div[data-testid="collapsedControl"] > img {
        height: 3rem;
        width: auto;
    }
    div[data-testid="stSidebarHeader"], div[data-testid="stSidebarHeader"] > *,
    div[data-testid="collapsedControl"], div[data-testid="collapsedControl"] > * {
        display: flex;
        align-items: center;
    }
    .st-emotion-cache-ocqkz7.e1f1d6gn5 {
        margin-bottom: -30px;
    }
</style>
"""
def apply_remove_sidebar_topspace() -> None:
    apply_html(REMOVE_SIDEBAR_TOPSPACE)


REMOVE_EXAMPLE_BOTTOMSPACE = """\
<style>
    .st-emotion-cache-ocqkz7.e1f1d6gn5 {{
        margin-bottom: {px}px;
    }}
</style>
"""
def apply_remove_example_bottomspace(px: int = 0) -> None:
    apply_html(REMOVE_EXAMPLE_BOTTOMSPACE.format(px=px))


ADD_CHAOS_EATER_ICON = """\
<style>
    .relative{
        position: relative;
        width: 120px;
    }
    .frame {
        display: inline-block;
        background-color: white;
        border: 1.5px solid black;
        border-radius: 50%;
        width: 120px;
        height: 120px;
    }
    .eye {
        display: inline-block;
        position: absolute;
        right: 40px;
        bottom: 48px;
        background-color: white;
        border-radius: 50%;
        width: 36px;
        height: 36px;
        z-index: 1;
    }
    .mask {
        overflow: hidden;
        position: absolute;
        right: 39px;
        bottom: 47.5px;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        z-index: 4;
    }
    .eyelid {
        display: inline-block;
        position: absolute;
        right: 0px;
        bottom: 0px;
        background-color: black;
        border-radius: 50% 50% 0% 0%;
        width: 40px;
        height: 40px;
        z-index: 5;
        animation-name: blink, blink2;
        animation-duration: 5s, 10s;
        animation-timing-function: linear, linear;
        animation-iteration-count: 1, infinite;
        animation-direction: normal, normal;
    }
    .pupil {
        display: inline-block;
        position: absolute;
        right: 10.5px;
        bottom: 10px;
        background-color: black;
        border-radius: 50%;
        width: 15px;
        height: 15px;
        z-index: 2;
    }
    .pupil_highlight {
        display: inline-block;
        position: absolute;
        right: 12.5px;
        bottom: 16.5px;
        background-color: white;
        border-radius: 50%;
        width: 5px;
        height: 5px;
        z-index: 3;
    }
    .chaoseater {
        position: absolute;
        right: -2px;
        bottom: 6px;
        z-index: 0;
        animation-name: rotation;
        animation-duration: 30s;
        animation-timing-function: linear;
        animation-iteration-count: infinite;
        animation-direction: normal;
    }
    @keyframes rotation{
        0%{ transform:rotate(0);}
        100%{ transform:rotate(-360deg); }
    }
    @keyframes blink {
        0% { transform: translateY(-100%);} 
        96%{ transform: translateY(-100%);}
        98%{ transform: translateY(0%);}
        100%{ transform: translateY(-100%);}
    }
    @keyframes blink2 {
        0% { transform: translateY(-100%);} 
        96%{ transform: translateY(-100%);}
        98%{ transform: translateY(0%);}
        100%{ transform: translateY(-100%);}
    }
</style>
<div class="stApp stAppEmbeddingId-s6iibfbv121p st-emotion-cache-ffhzg2 erw9t6i1">

<script>
    document.addEventListener('mousemove', function(event) {
        const eyes = document.querySelectorAll('.eye');
        eyes.forEach(eye => {                      
            const rect = eye.getBoundingClientRect();
            const eyeCenterX = rect.left + rect.width / 2;
            const eyeCenterY = rect.top + rect.height / 2;
            const deltaX = event.clientX - eyeCenterX;
            const deltaY = event.clientY - eyeCenterY;
            const angle = Math.atan2(deltaY, deltaX);
            const distance = Math.min(Math.min(rect.width / 4, 20), Math.sqrt(deltaX * deltaX + deltaY * deltaY));
            const pupilX = distance * Math.cos(angle);
            const pupilY = distance * Math.sin(angle);
            const pupil = eye.querySelector('.pupil');
            const pupil_highlight = eye.querySelector('.pupil_highlight');
            pupil.style.transform = `translate(${pupilX}px, ${pupilY}px)`;
            pupil_highlight.style.transform = `translate(${pupilX}px, ${pupilY}px)`;
        });
    });
    document.addEventListener('mouseleave', function(event) {
        const eyes = document.querySelectorAll('.eye');
        eyes.forEach(eye => {                      
            const pupil = eye.querySelector('.pupil');
            const pupil_highlight = eye.querySelector('.pupil_highlight');
            pupil.style.transform = `translate(0px, 0px)`;
            pupil_highlight.style.transform = `translate(0px, 0px)`;
        });
    });
</script>
<center> 
    <div class="relative">
        <span class="eye"> 
            <span class="pupil"></span>
            <span class="pupil_highlight"></span>
        </span>
        <div class="mask">
            <span class="eyelid"></span>
        </div>
        <img src="./app/static/chaoseater_icon.png" class="chaoseater" alt="ChaosEater" width="120" height="120"> 
        <span class="frame"> </span>
    </div>
</center>
</div>
"""
def add_chaoseater_icon() -> None:
    components.html(ADD_CHAOS_EATER_ICON)


# ref: https://discuss.streamlit.io/t/remove-hide-running-man-animation-on-top-of-page/21773/3
HIDE_ST_STYLE = """\
<style>
    div[data-testid="stToolbar"] {
        visibility: hidden;
        height: 0%;
        position: fixed;
    }
    div[data-testid="stDecoration"] {
        visibility: hidden;
        height: 0%;
        position: fixed;
    }
    div[data-testid="stStatusWidget"] {
        visibility: hidden;
        height: 0%;
        position: fixed;
    }
    #MainMenu {
        visibility: hidden;
        height: 0%;
    }
    header {
        visibility: hidden;
        height: 0%;
    }
    footer {
        visibility: hidden;
        height: 0%;
    }
</style>
"""
def apply_hide_st_style() -> None:
    apply_html(HIDE_ST_STYLE)

# ref: https://github.com/streamlit/streamlit/issues/6605
HIDE_HEIGHT0_COMPONENTS = """\
<style>
    .element-container:has(iframe[height="0"]) {{
        display: none;
    }}
</style>
"""
def apply_hide_height0_components():
    apply_html(HIDE_HEIGHT0_COMPONENTS)

CENTERIZE_COMPONENTS_VERTICALLY = """\
<style>
    [data-testid="stHorizontalBlock"] {
        align-items: center;
    }
</style>
"""
def apply_centerize_components_vertically():
    apply_html(CENTERIZE_COMPONENTS_VERTICALLY)

# stand-alone spiner in streamlit
# ref: https://github.com/streamlit/streamlit/issues/6799
# Thank the authors for the excelent hack
class st_spinner:
    def __init__(self, text = "In progress..."):
        self.text = text
        self._spinner = iter(self._start()) # This creates an infinite spinner
        next(self._spinner) #  This starts it
        
    def _start(self):
        with st.spinner(self.text):
            yield 
    
    def end(self): # This ends it
        next(self._spinner, None)