import os
import time
import json
import streamlit as st
from streamlit_extras.bottom_container import bottom

from ChaosEater_demo import WORK_DIR, NAMESPACE, CHAOSEATER_ICON, CHAOSEATER_IMAGAE
from chaos_eater.utils.app_utils import (
    apply_hide_st_style,
    apply_hide_height0_components,
    apply_centerize_components_vertically,
    apply_remove_sidebar_topspace,
    add_chaoseater_icon,
    apply_remove_example_bottomspace
)
from chaos_eater.ce_tools.ce_tool import CEToolType, CETool
from chaos_eater.utils.llms import load_llm
from chaos_eater.utils.functions import (
    load_json,
)
from chaos_eater.postprocessing.postprocessor import PostProcessor
from chaos_eater.preprocessing.preprocessor import ProcessedData
from chaos_eater.hypothesis.hypothesizer import Hypothesis
from chaos_eater.experiment.experimenter import ChaosExperiment, ChaosExperimentResult
from chaos_eater.analysis.analyzer import Analysis
from chaos_eater.improvement.improver import ReconfigurationResult
from chaos_eater.chaos_eater import ChaosCycle

def init_agent(
    model_name: str = "openai/gpt-4o",
    temperature: float = 0.0,
    port: int = 8000,
    seed: int = 42
) -> None:
    llm = load_llm(
        model_name=model_name, 
        temperature=temperature,
        port=port,
        model_kwargs={"seed": seed}
    )
    st.session_state.post_processor = PostProcessor(llm)
    st.session_state.model_name = model_name


def main():
    #---------------------------
    # initialize session states
    #---------------------------
    if "state_list" not in st.session_state:
        st.session_state.state_list = {}
    if "chat_history" not in st.session_state:
        st.session_state.chat_history = []
    if "count" not in st.session_state:
        st.session_state.count = 0
    if "instructions" not in st.session_state:
        st.session_state.instructions = None
    if "is_first_run" not in st.session_state:
        st.session_state.is_first_run = True
    if "submit" not in st.session_state:
        st.session_state.submit = False

    #--------------
    # CSS settings
    #--------------
    st.set_page_config(
        page_title="Summary demo",
        page_icon=CHAOSEATER_IMAGAE,
    )
    # st.set_page_config(layout="wide")
    apply_hide_st_style()
    apply_hide_height0_components()
    apply_centerize_components_vertically()
    apply_remove_sidebar_topspace()

    #---------
    # sidebar
    #---------
    st.logo("static/chaoseater_icon.png")
    with st.sidebar:
        # settings
        with st.expander("Settings", expanded=True):
            model_name = st.selectbox(
                "Model", 
                (
                    "openai/gpt-4o-2024-08-06",
                    "openai/gpt-4o-2024-05-13",
                    "google/gemini-1.5-pro",
                    "anthropic/claude-3-5-sonnet-20240620",
                    "meta-llama/Meta-Llama-3-70B-Instruct"
                )
            )
            if model_name.startswith("openai"):
                st.text_input(
                    label="API keys",
                    key="openai_key",
                    placeholder="OpenAI API key",
                    type="password"
                )
            else:
                st.text_input(
                    label="Token",
                    key="hf_token",
                    placeholder="Hugging Face token",
                    type="password"
                )
            subphase_type = st.selectbox(
                "Sub-phase", 
                (
                    "Experiment planning",
                    "Workflow conversion",
                    "Experiment execution"
                )
            )        

    #--------------------------------
    # initialize plan2workflow agent
    #--------------------------------
    if "post_processor" not in st.session_state or model_name != st.session_state.model_name:
        init_agent(model_name=model_name)

    # greeding 
    if len(st.session_state.chat_history) == 0 and st.session_state.is_first_run:
        add_chaoseater_icon()
        greeding = "Here is a demo space for the Experiment Phase. You can start from the Experiment phase by inputting result files (JSON format) so far."
        st.markdown(f'<center> <h3> {greeding} </h3> </center>', unsafe_allow_html=True)
    if st.button("Try"):
        st.session_state.submit = True

    #--------------
    # current chat
    #--------------
    if st.session_state.submit:
        with st.chat_message("assistant", avatar=CHAOSEATER_ICON):
            data_dir = "sandbox/cycle_20240924_141403"
            ce_cycle = ChaosCycle(**load_json(f"{data_dir}/outputs/ce_cycle.json"))
            work_dir="summary_test"
            os.makedirs(work_dir, exist_ok=True)
            st.write(ce_cycle.to_str())
            summary_log, summary = st.session_state.post_processor.process(
                ce_cycle=ce_cycle,
                work_dir=work_dir
            )
    st.session_state.count += 1

if __name__ == "__main__":
    main()