% parameters

d = 100; % dimension of the input vector

r = 30;  % number of the non-pruned weights in each neuron

N = 300; % number of samples

K = 5; % number of neurons in the hidden layer

x = randn( d , N ); % generate input data

P = P_generator( d, K, r ); % generate Mask matrix

W = (1*rand( d , K )-0.5) .* P; % generate weights matrix

y = y_snn(x , W); % generate output label

T = 10000; % number of iterations

eta = 0.5; 

beta = 0.2;

error_ite = nan(T,1); 

W_0 = (1*rand( d , K )-0.5) .* P;

W_t = W_0;

W_pre = W_t;

for t = 1 : T
    
    W_cur = W_t;
    
    G = Gradient_snn( y, x, W_t, P);
     
    W_t = W_t - eta * G + beta * (W_cur - W_pre);
    
    W_pre = W_cur; 
    
    error_ite(t) = norm( W_t - W,  'fro' )/ norm(W , 'fro');
    
end

figure(1);

semilogy(error_ite,'b', 'linewidth', 2);

axis on; 
grid on;
xlabel('Number of Iterations');
ylabel('Relative error');
set(gca,'fontsize',18,'fontname', 'Times New Roman');





function [ y ] = y_snn( x , w )

[ ~ , N ] = size( x );

[ ~ , K ] = size( w );

y = zeros( 1,N );

for j = 1 : K
    
    y = y + 1/K * max(w( :, j)' * x,0);
    
end
end

function [P] = P_generator(d,K,r)

P = zeros( d , K);

for j = 1 : K
    
    index = randsample(d,r);
    
    P( index, j ) = 1;
    
end

end


function [G] = Gradient_snn(y, x, W, P)

y_e = y_snn(x , W);

[d, K] = size( W);

G = zeros( d , K);

for j = 1 : K
    
    G(: , j) = mean( repmat(( y_e - y ) .* (W(:,j)' * x > 0), d , 1 ) .* x, 2);
    
end

G = G .* P;

end