% parameters

d = 300;

r_vec = 20 :10: 150; % sparsity

N = 3000; % number of samples

K = 5; % number of neurals in the hidden layer

T = 2000;

err = nan(T,length(r_vec));

err_GD = nan(T,length(r_vec));

rate = nan(length(r_vec),1);

rate_GD = nan(length(r_vec),1);

for k_number = 1 : length(r_vec)
    
    r = r_vec( k_number );
    
    x = randn( d , N );
    
    P = P_generator( d, K, r );
    
    W = 5 *(1*rand( d , K )-0.5) .* P;
    
    y = y_snn(x , W , P);
    
    eta = 0.5;
    
    beta = 0.2;
    
    temp = rand(d,K).* P;
    
    W_0 = W + 0.5 * temp / norm(temp, 'fro') * norm(W , 'fro');
    
    W_t = W_0 .* P;
    
    fprintf('r= %d, loop numer =     ', r );
    
    W_pre = W_t;
    
    for t = 1 : T
        
        W_cur = W_t;
        
        fprintf('\b\b\b\b\b%4d\n', t);
        
        G = Gradient_snn( y, x, W_t, P);
        
        W_t = W_t - eta * G + beta * ( W_cur- W_pre );
        
        W_pre = W_cur;
        
        error = norm( W-W_t , 'fro') / norm( W , 'fro');
        
        err( t, k_number ) = error;
        
        if error < 10^-8
            
            break;
            
        end
        
    end
    
    rate( k_number ) = exp( 1 / t * log( error / 0.5 ) );
    
    
    W_t = W_0 .* P;
    
    fprintf('r= %d, loop numer =     ', r );
    
    W_pre = W_t;
    
    for t = 1 : T
        
        fprintf('\b\b\b\b\b%4d\n', t);
        
        W_cur = W_t;
        
        G = Gradient_snn( y, x, W_t, P);
        
        W_t = W_t - eta * G + 0 * ( W_cur- W_pre );
        
        W_pre = W_cur;
        
        error_GD = norm( W-W_t , 'fro') / norm( W , 'fro');
        
        err_GD( t, k_number ) = error_GD;
        
        if error_GD < 10^-8
            
            break;
            
        end
        
    end
    
    rate_GD( k_number ) = exp( 1 / t * log( error_GD / 0.5 ) );
    
end


