% Parameter

N_vec = 50:50:700; % sampling number

K = 5;    % number of nodes in hidden layer

d = 100;   % dimension of raw data

r_vec = 10:10:100;

loop_n = 5000;

Trail_number = 100;

ERR_AGD = nan ( length( N_vec ) , length ( r_vec ) , Trail_number );


for loop_N = 1: length ( N_vec )
    
    N = N_vec ( loop_N );
    
    for loop_p = 1: length ( r_vec )
        
        r = r_vec ( loop_p );
        
        eta = 0.5; % stepsize of gradient descent
        
        for loop_t = 1: Trail_number
            
            x = randn( d , N );
            
            P = P_generator( d, K, r );
            
            W = 5 *(1*rand( d , K )-0.5) .* P;
            
            y = y_snn(x , W , P);
            
            T = 10000;
            
            eta = 0.5;
          
            
            temp = rand(d,K).* P;
            
            W_0 = W + 0.1 * temp / norm(temp, 'fro') * norm(W , 'fro');
            
            fprintf( 'AGD with N = %d , r = %d , trail = %d \n', N , r  , loop_t );
            
            W_t =  GD_SNN(y,x,W_0,P,T,eta);
            
            ERR_AGD( loop_N , loop_p , loop_t ) = norm ( W_t - W , 'fro' ) / norm ( W , 'fro' );
            
            
        end
        
    end
    
end