% Parameter

d = 300;
r_vec = 10:10:100; % sparsity

N = 1000;

noise_vec = 1 * 10.^-(2:6);
K = 5;    % number of nodes in hidden layer
% d = p / M;    % dimension of patches
T = 5000;
eta = 0.4; % stepsize of gradient descent
beta = 0.2; % stepsize of Heavy-ball 

Trail_number = 1;

%ERR_GD = nan ( length( N_vec ) , Trail_number );

ERR_AGD = nan ( length(noise_vec), length( r_vec ) , Trail_number );



for loop_p = 1: length ( noise_vec )
    
    noise = noise_vec ( loop_p );
    
    for loop_N = 1 : length ( r_vec )
        
        r = r_vec(loop_N);
        
        for loop_t = 1: Trail_number
            
            %             N = N_vec ( loop_N );
            
            x = randn( d , N );
            
            P = P_generator( d, K, r );
            
            W = 20 *(1*rand( d , K )-0.5) .* P;
            
            y = y_snn(x , W , P);
            
            y = y + noise * ( norm( y , 'fro' )/ sqrt( N ) ) * randn( 1 , N );
            
            temp = randn( d , K );
            
            W_0 = W + 0.9 * norm( W , 'fro' ) * temp / norm( temp ,  'fro' );
            
            W_0 = W_0 .* P;
            
            fprintf( 'noise = %d , AGD with r = %d , trail = %d \n', noise , r  , loop_t );
            
            W_t = GD_SNN(y,x,W_0,P,T,eta);
            
            ERR_AGD( loop_p , loop_N , loop_t ) = norm ( W_t - W , 'fro' ) / norm ( W , 'fro' );
            
        end
    end
end