subplot(1,2,1)

semilogy(err(:,1)', 'b-*', 'MarkerIndices',1:80:2000, 'MarkerSize',10, 'linewidth', 2);

hold on;

semilogy(err(:,4)',  'r-o', 'MarkerIndices',1:80:2000, 'MarkerSize',10, 'linewidth',2);

hold on;

semilogy(err(:,7)',  'k-d','MarkerIndices',1:100:2000, 'MarkerSize',10, 'linewidth',2);

hold on;

semilogy(err(:,10)',  'g-x','MarkerIndices',1:100:2000, 'MarkerSize',10,'linewidth',2);

hold on;

semilogy(err(:,13)',  'm-s', 'MarkerIndices',1:100:2000,'MarkerSize',10,'linewidth',2);

hold on;

grid on;

axis on; 
xlabel('Number of iterations');
ylabel('Relative error');
%set(gca,'XTick',[1 3 5 7 9]);
%set(gca,'Xticklabel',{'10','30','50','70','90'});
%set(gca,'YTick',[1 3 5 7 9 11 13]);
%set(gca,'Yticklabel',{'50','150','250', '350', '450', '550','650'});
legend( 'r=10' , 'r=40', 'r=70', 'r=100', 'r=130')

set(gca,'fontsize',16,'fontname', 'Times New Roman');

subplot(1,2,2)

plot(sqrt(r_vec), rate, 'b-o','MarkerSize',10, 'linewidth', 2);

hold on;

plot(sqrt(r_vec), rate_GD, 'r-*','MarkerSize',10, 'linewidth', 2);


ylabel('Convergence rate');
xlabel('$\sqrt{r}$');

legend('AGD ($\beta=0.2$)', 'GD ($\beta=0$)')

set(gca,'fontsize',16,'fontname', 'Times New Roman');